<?php
    $currentPage = 'users';
?>
<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class = "dashboard-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-4 col-lg-4 mb-2">
                            <div class="card event-card total-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>Admins</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($countAdmins); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-lg-4 mb-2">
                            <div class="card event-card complete-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>Organizer</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($countOrganizers); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-lg-4 mb-2">
                            <div class="card event-card inprogress-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>Auditor/User</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($countUsers); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>






                <div class="col-12 mb-2">
                    <div class="card">
                        <div class="card-header border-bottom">
                            <div class="row ">
                                <div class="col-sm-7 col-md-6 col-lg-4 mb-3 mb-md-0">
                                    <div class="form-group">
                                        <input type="text" class="form-control" placeholder = "Search by Name or Email"
                                            oninput="searchUser(this.value)" value="<?php if($search!=null): ?><?php echo e($search); ?><?php endif; ?>" />
                                    </div>
                                </div>
                                <div class="col-sm-5 col-md-6 col-lg-8 text-md-end">
                                    <a href = "<?php echo e(route('users.create')); ?>"
                                        class="btn btn-secondary add-new btn-primary btn-full-sm full-width-sm"
                                        type="button">
                                        <span>
                                            <i class="bx bx-plus me-0 me-sm-1"></i>
                                            <span>Add User</span>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="text-nowrap table-responsive user-table">

                            <table class="table mb-4 table-hover">
                                <thead>
                                    <tr>
                                        <th>
                                            User Name
                                        </th>
                                        <th>
                                            Email Address
                                        </th>
                                        <th>
                                            Role
                                        </th>
                                        <th>
                                            Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0" id="userTableData">

                                </tbody>
                            </table>
                            
                            <div class="d-flex justify-content-center" id="page-links">

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>
    <!-- / Content -->
    <script>
        $(document).ready(function() {

            var data = <?php echo json_encode($users->toJson()); ?>;

            data = JSON.parse(data);

            var search="<?php echo $search; ?>";
            if(search==''){
                search=null;
            }

            //console.log(data);
            var html = paginationHtml(data.links,'users',search);
            $("#page-links").html(html);
            showData(data, 'userTableData');
        });

        function searchUser(value) {

            var url = "<?php echo e(route('searchUser')); ?>";
            var method = 'POST';
            var dataType = "json";
            var page = "<?php echo e(app('request')->input('page')); ?>";
            var parameters = {
                search: value,

            };
            requestAjax(url, method, dataType, parameters)
                .then(response => {
                    console.log(response.links);
                    var html = paginationHtml(response.links,'users',value);
                    $("#page-links").html(html);
                    showData(response, 'userTableData');
                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });


        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8\htdocs\Booth-management\resources\views/admin/users/index.blade.php ENDPATH**/ ?>