<?php

use App\Http\Controllers\Admin\BoothController;
use App\Http\Controllers\Admin\EventController;
use App\Http\Controllers\Admin\RoleController;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\HallController;

$proxy_url    = getenv('PROXY_URL');
$proxy_schema = getenv('PROXY_SCHEMA');

if (!empty($proxy_url)) {
    URL::forceRootUrl($proxy_url);
}

if (!empty($proxy_schema)) {
    URL::forceScheme($proxy_schema);
}
#####################################
Route::get('/', function () {
    return redirect()->route('login');
});
Route::get('/logout', function () {
    return redirect()->route('login');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/profile', [App\Http\Controllers\HomeController::class, 'profile'])->name('profile');
Route::put('/profile/{user}', [App\Http\Controllers\HomeController::class, 'update'])->name('profile.update');
Route::middleware('auth')->group(function () {
    Route::resource('users', UserController::class);
    Route::post('search-user',[UserController::class,'searchUser'])->name('searchUser');
    Route::resource('roles',RoleController::class);
    Route::resource('events',EventController::class);
    Route::post('events/stats', [EventController::class, 'getStats'])->name('event.stats');
    Route::post('events/import',[EventController::class,'import'])->name('events.import');
    Route::get('booth/detail/{id}',[BoothController::class,'showDetail'])->name('booth.detail');
    Route::get('booth/allow-edit/{id}', [BoothController::class, 'allowEdit'])->name('booth.allowEdit');
    Route::get('booth/delete/{id}', [BoothController::class, 'destroy'])->name('booth.delete');
    Route::get('booth/allow-admin-edit/{id}', [BoothController::class, 'allowAdminEdit'])->name('booth.allowAdminEdit');
    Route::post('booth/detail/{id}', [BoothController::class, 'storeDetail'])->name('booth.detail.store');
    Route::post('booth/rating',[BoothController::class,'getRating'])->name('booth.rating');
    Route::resource('booths', BoothController::class);
    Route::post('search-event', [EventController::class, 'searchEvent'])->name('searchEvent');
    Route::post('search-booth', [BoothController::class, 'searchBooth'])->name('searchBooth');
    Route::post('booths/import', [BoothController::class, 'import'])->name('booths.import');
    Route::post('update-hall',[HallController::class,'update'])->name('hall.update');
    Route::post('search-booth-by-hall', [BoothController::class, 'searchBoothByHall'])->name('searchBoothByHall');
    Route::post('search-booth-by-stand', [BoothController::class, 'searchBoothByStand'])->name('searchBoothByStand');
    Route::get('booths-export/{event_id}', [BoothController::class, 'export'])->name('booths.export');
    Route::get('/download-sample', [BoothController::class, 'downloadSample'])->name('download.sample');
    Route::get('booth/download-sample', [BoothController::class, 'downloadBoothSample'])->name('booth.download.sample');
});
