@extends('layouts.app')
@php
    $currentPage = 'profile';
@endphp
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-md-12 col-lg-8 col-xl-7">
                <div class="card mb-2">
                    <div class="card-body">

                        <form action="{{ route('profile.update',$user->id) }}" id="registrationForm" method="post">
                            @csrf
                            <input type="hidden" name="_method" value="put">
                            <div class="mb-3">
                                <label for="username" class="form-label">Name</label>
                                <input type="text" class="form-control" id="username" name="name" placeholder="Name" value="{{ old('name',$user->name) }}" autofocus>
                                <div id="usernameError" class="form-error mt-1">@error('name'){{ $message }}@enderror</div>
                            </div>
                            <div class="mb-3">
                                <label for="userEmail" class="form-label">Email address</label>
                                <input type="email" class="form-control" value="{{ old('email',$user->email) }}" id="userEmail" name="email" placeholder="name@example.com"
                                    autofocus readonly>
                                <div id="userEmailError" class="form-error mt-1">@error('email'){{ $message }}@enderror</div>
                            </div>

                            <div class="mb-3 form-password-toggle">
                                <div class="row align-items-end">
                                    <div class="col-md-8 mb-3 mb-md-0">
                                        <label for="userPassword" class="form-label">Password</label>
                                        <div class="input-group input-group-merge">
                                            <input type="password" id="password"  class="form-control" name="password"
                                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                                aria-describedby="password" />
                                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <button class="btn btn-outline-secondary w-100" id="generatePassword">
                                            Generate Password
                                        </button>
                                    </div>
                                    <div id="passwordError" class="form-error mt-1">@error('password'){{ $message }}@enderror</div>
                                </div>
                            </div>
                            {{-- <div class="mb-3">
                                <label for="exampleFormControlSelect2" class="form-label">Assigine Events</label>
                                <select multiple="" class="form-select multiselect-events" id="exampleFormControlSelect2"
                                    aria-label="Multiple select example" multiple="multiple">
                                    <option selected="">Event Name</option>
                                    <option value="1">Event One</option>
                                    <option value="2">Event Two</option>
                                    <option value="3">Event Three</option>
                                </select>
                            </div> --}}
                            <div class="mb-3">
                                <label for="userSelect" class = "form-label">User Role</label>
                                <select id="roleSelect" class="form-select usertype-select wide mb-4" name="role" disabled>
                                    <option data-display = "Select">Noting</option>
                                    <option value="Super Admin" @if(old('role',$user->roles[0]->name)=='Super Admin')selected @endif >Super Admin</option>
                                    <option value="Admin" @if(old('role',$user->roles[0]->name)=='Admin')selected @endif >Admin</option>

                                    <option value="Organizer" @if(old('role',$user->roles[0]->name)=='Organizer') selected @endif>Organizer</option>
                                    <option value="User" @if(old('role',$user->roles[0]->name)==null || old('role',$user->roles[0]->name)=='User') selected @endif>Auditor/User</option>
                                </select>
                                <div id="roleSelectError" class="form-error mt-1"></div>
                            </div>
                            <div class="mb-3 mt-4">
                                <div class="row">
                                    <div class="col-12 text-end">
                                        <a href = "{{ route('users.index') }}" type="reset" class="btn btn-outline-secondary">Cancel</a>
                                        <button type="submit" class="btn btn-primary">
                                            Update
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>
    <!-- / Content -->


    <script>
        $(document).ready(function() {
            $.validator.addMethod("passwordPattern", function(value, element) {
                    return this.optional(element) ||
                        /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]).{8,}$/.test(
                            value);
                },
                "Your password must contain at least one uppercase letter, one lowercase letter, one number, and one special character."
            );
            $.validator.addMethod('selectcheck', function (value) {
                return (value != '');
            }, "Value required");

            $('#registrationForm').validate({
                ignore: [],
                rules: {
                    password: {

                        minlength: 8,
                        passwordPattern: true
                    },
                    name: {
                        required: true,
                        noNumbers: true,
                        // maxlength: 32
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    role:{
                        selectcheck: true
                    }
                },
                messages: {
                    password: {
                        required: "Please enter a password",
                        minlength: "Your password must be at least 8 characters long",
                        passwordPattern: "Your password must contain at least one uppercase letter, one lowercase letter, one number, and one special character."
                    },

                    name: {
                        required: "Please provide your full name",
                        maxlength: "Your name must not exceed 32 characters",
                        noNumbers: "Your name cannot contain any numbers."
                    },
                    email: {
                        required: "Please enter your email address",
                        email: "Please enter a valid email address"
                    },
                    role: {
                        required: "Please  select one role"
                    }
                },
                errorPlacement: function(error, element) {
                    var errorElementId = element.attr('id') +
                        'Error'; // Get the ID of the corresponding error message div
                    $('#' + errorElementId).text(error
                        .text()
                        ); // Insert the error message text into the corresponding error message div
                },
                highlight: function(element, errorClass, validClass) {
                    var value = $(element).val();
                    var hasUpperCase = /[A-Z]/.test(value);
                    var hasLowerCase = /[a-z]/.test(value);
                    var hasNumber = /\d/.test(value);
                    var hasSpecialChar = /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(value);
                    var passwordLength = value.length;

                    // Check if the element being validated is the password field
                    if (element.id === 'password') {
                        if (hasUpperCase) {
                            $('.password-instruction b:contains("uppercase")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("uppercase")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasLowerCase) {
                            $('.password-instruction b:contains("lowercase")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("lowercase")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasNumber) {
                            $('.password-instruction b:contains("number")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("number")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasSpecialChar) {
                            $('.password-instruction b:contains("special character")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("special character")').addClass(
                                'invalid').removeClass('valid');
                        }

                        if (passwordLength >= 8) {
                            $('.password-instruction').find('b:contains("8")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction').find('b:contains("8")').addClass('invalid')
                                .removeClass('valid');
                        }
                    }
                },
                unhighlight: function(element, errorClass, validClass) {
                    var errorElementId = $(element).attr('id') + 'Error';
                    $('#' + errorElementId).empty();
                },
                submitHandler: function(form) {
                    form.submit(); // Submit the form if all validation passes
                }
            });

            $.validator.addMethod("noNumbers", function(value, element) {
                return this.optional(element) || !/\d/.test(value);
            }, "Your name cannot contain any numbers.");

            $('#registrationForm input').keyup(function() {
                $('#registrationForm').validate().element($(this));
            });
            $("#generatePassword").click(function(event){
                event.preventDefault();
               var pass=generatePassword();
               $("#password").val(pass);
            });
        });
    </script>
@endsection
