<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booth extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable=['number','size','exhibitor_name','event_id','hall_id','stand_type_id', 'contractor_name', 'contractor_email', 'contractor_phone','length','width'];
    public function event(){
        return $this->belongsTo(Event::class);
    }
    public function rating(){
        return $this->hasMany(BoothRating::class,'booth_id');
    }
    public function userRating()
    {
        return $this->rating()->where('user_id', auth()->id());
    }
    public function hasUserRating()
    {
        return $this->rating()->exists();
    }
    public function hall(){
        return $this->belongsTo(Hall::class);
    }
    public function standType(){
        return $this->belongsTo(StandType::class);
    }
   public function comment(){
        return $this->hasOne(Comment::class,'booth_id');
   }
}
