<?php
    $currentPage = 'booth-details';
    $eventName = $booth->event->name;
    $event_id = $booth->event->id;
?>
<?php $__env->startSection('head'); ?>
    <!-- LightBox Gallery -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/libs/lightbox-gallery/gallery.css')); ?>">
    <script src = "<?php echo e(asset('assets/libs/lightbox-gallery/gallery.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="container-xxl flex-grow-1 container-p-y">


        <?php if(!$submitted || ((Auth::user()->getRoleNames()->first()=='Admin' || Auth::user()->getRoleNames()->first()=='Super Admin') && $adminEdit) ): ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add-rating')): ?>
                <div class="dashboard-body">
                    <div class="row">

                        <div class="col-12 mb-2 d-none">
                            <div class="card">
                                <div class="card-header border-bottom">
                                    <div class="booth-detail-header">
                                        <div class="row align-items-center justify-content-between">
                                            <div class="col-sm-6 mb-1 mb-sm-0">
                                                <div class="exb-name">
                                                    <h6 class = "mb-2">Exhibitor Name</h6>
                                                    <h4><?php echo e($booth->exhibitor_name); ?></h4>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 text-sm-end">
                                                <div class="booth-num mb-2">
                                                    Stand Number: <span class="ms-2"><?php echo e($booth->number); ?></span>
                                                </div>
                                                <div class="booth-size mb-2">
                                                    Stand Size M<sup>2</sup>: <span class="ms-2"><?php echo e($booth->size); ?></span>
                                                </div>
                                                <div class="reating-by">
                                                    Stand assessment by: <span
                                                        class="ms-2"><?php echo e($assessmentByUser); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-6 col-lg-3 mb-2 mb-lg-0">
                                    <div class="card event-card total-event h-100">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Exhibitor Name</span>
                                                    <h5 class="card-title mb-1"><?php echo e($booth->exhibitor_name); ?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-3 mb-2 mb-lg-0">
                                    <div class="card event-card complete-event h-100">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Stand Number</span>
                                                    <h5 class="card-title text-nowrap mb-1"><?php echo e($booth->number); ?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-3 mb-2 mb-lg-0">
                                    <div class="card event-card inprogress-event h-100">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Stand Size m<sup>2</sup></span>
                                                    <h5 class="card-title text-nowrap mb-1"><?php echo e($booth->size); ?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-3 mb-2 mb-lg-0">
                                    <div class="card event-card inprogress-event h-100">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Stand assessment by</span>
                                                    <h5 class="card-title text-nowrap mb-1"><?php echo e(Auth::user()->name); ?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class = "dashboard-body mt-2">

                    <div class = "row">
                        <?php if(session()->has('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php elseif(session()->has('failed')): ?>
                            <div class="alert alert-danger">Some Error Occured!</div>
                        <?php endif; ?>
                        <div class = "card event-card px-3 py-2" id = "stickyHeader">
                            <div class = "row align-items-center">
                                <div class = "col-md-6">
                                    <h4 class="my-3 fr-h4">
                                        Please fillout the Stand Criteria information:
                                    </h4>
                                </div>
                                <div class = "col-md-6 mb-2 mb-md-0">
                                    <div class = "booth-update d-flex align-items-center">
                                        <label>Stand Rating from Submitted info</label>
                                        <div class = "rating-badge <?php if($rating != null && $rating != 'NOT'): ?> <?php echo e(strtolower($rating)); ?> <?php endif; ?>"
                                            id="ratingCategory">
                                            <div class="cb-icon">
                                                <img class = "gold-img"
                                                    src="<?php echo e(asset('assets/images/elements/Gold-star.svg')); ?>" alt="Gold star"
                                                    class="rounded">
                                                <img class = "silver-img"
                                                    src="<?php echo e(asset('assets/images/elements/Silver-star.svg')); ?>" alt="Gold star"
                                                    class="rounded">
                                                <img class = "bronze-img"
                                                    src="<?php echo e(asset('assets/images/elements/Bronze-star.svg')); ?>" alt="Gold star"
                                                    class="rounded">
                                            </div>
                                            <span class = "gold-text">Gold</span>
                                            <span class = "silver-text">Silver</span>
                                            <span class = "bronze-text">Bronze</span>
                                            <span class = "disposable-text">Disposable</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="rating-form rating-inline pt-2 pb-3">
                            <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
                            <form action="<?php echo e(route('booth.detail.store', $booth->id)); ?>" method="post" class = "rating-form"
                                id="ratingForm" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php
                                    $index = 0;
                                ?>
                                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $index++;
                                    ?>
                                    <div class="col-12 mb-2">
                                        <div class="card">
                                            <div class="form-group border-bottom row px-3 mx-0 align-items-center">

                                                <div class = "d-flex">
                                                    <div class = "number-side py-3 w-auto pe-3">
                                                        <div class="label-question">
                                                            <?php echo e($index . '.'); ?>

                                                        </div>
                                                    </div>
                                                    <div class = "question-side">
                                                        <div class="col-12 py-3">
                                                            <div class="label-question">
                                                                <?php echo e($question->name); ?>

                                                            </div>
                                                        </div>

                                                        <div class = "col-12 pb-3">
                                                            <ul class = "nav gap-2">
                                                                <div class="form-row flex-center">
                                                                    <input class="form-input yes" type="radio"
                                                                        name="<?php echo e('criteria_' . $question->id); ?>"
                                                                        id="<?php echo e($question->id); ?>_yes" value="yes"
                                                                        onchange="handleRadioChange(event,'<?php echo e($question->slug); ?>')"
                                                                        <?php if(isset($question->rating->result) && $question->rating->result == 'yes'): ?> <?php echo e('checked'); ?> <?php endif; ?>>
                                                                    <label class="form-label"
                                                                        for="<?php echo e($question->id); ?>_yes">YES</label>
                                                                </div>
                                                                <div class="form-row flex-center">
                                                                    <input class="form-input no" type="radio"
                                                                        name="<?php echo e('criteria_' . $question->id); ?>"
                                                                        id="<?php echo e($question->id); ?>_No" value="no"
                                                                        onchange="handleRadioChange(event,'<?php echo e($question->slug); ?>')"
                                                                        <?php if(isset($question->rating->result) && $question->rating->result == 'no'): ?> <?php echo e('checked'); ?> <?php endif; ?>>
                                                                    <label class="form-label"
                                                                        for="<?php echo e($question->id); ?>_No">NO</label>
                                                                </div>
                                                                <div class="form-row flex-center">
                                                                    <input class="form-input na" type="radio"
                                                                        name="<?php echo e('criteria_' . $question->id); ?>"
                                                                        id="<?php echo e($question->id); ?>_N/A" required value="na"
                                                                        onchange="handleRadioChange(event,'<?php echo e($question->slug); ?>')"
                                                                        <?php if(isset($question->rating->result) && $question->rating->result == 'na'): ?> <?php echo e('checked'); ?> <?php endif; ?>>
                                                                    <label class="form-label"
                                                                        for="<?php echo e($question->id); ?>_N/A">N/A</label>
                                                                </div>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <input type="hidden" name="assesment_by" value="<?php echo e(Auth::user()->id); ?>">
                                <div class="col-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="form-group">
                                                <div class = "upload-img mt-3">
                                                    <div class="mx-4">
                                                        <label for="comment">Comments</label>
                                                        <textarea name="comment" id="comment" class="form-control mb-5" style="border:1px solid black" rows="10"><?php if($comment!=null): ?><?php echo e($comment->comment); ?><?php endif; ?></textarea>
                                                    </div>

                                                    <label>Upload Stands Photos</label>
                                                    <div class = "image-section">
                                                        <div class = "img-placeholder">
                                                            <div class = "user-img-ic">
                                                                <img src = "<?php echo e(asset('assets/images/icons/upload-product.svg')); ?>"
                                                                    alt = "icon" />
                                                            </div>
                                                            <div class = "title">
                                                                Drop files here or browse to upload <br>
                                                                Your can upload multiple photos here
                                                            </div>
                                                            <div class = "img-dimensions mt-2">
                                                                Up to 1 MB (JPG or PNG)
                                                            </div>
                                                        </div>
                                                        <!--<div class = "image-show" style="display: none;">
                                                                                                                                                                                                    <div class = "img-details">
                                                                                                                                                                                                        <ul class = "nav">
                                                                                                                                                                                                            <li class = "nav-item">
                                                                                                                                                                                                                <div class = "uploaded-image">
                                                                                                                                                                                                                    <img id="uploaded-image-preview" src="" alt="Uploaded Image" />
                                                                                                                                                                                                                </div>
                                                                                                                                                                                                            </li>
                                                                                                                                                                                                            <li class = "nav-item">
                                                                                                                                                                                                                <div class = "product-name" id="product-name"></div>
                                                                                                                                                                                                                <div class = "product-size" id="product-size"></div>
                                                                                                                                                                                                            </li>
                                                                                                                                                                                                        </ul>
                                                                                                                                                                                                    </div>
                                                                                                                                                                                                    <div class="progress" style="height: 2px;">
                                                                                                                                                                                                    <div class="progress-bar" id="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                                                                                                                                                                                                    </div>
                                                                                                                                                                                                    <div class = "close-sec">
                                                                                                                                                                                                    </div>
                                                                                                                                                                                                </div>-->
                                                        <input id = "upload-img-pu" type="file" accept="image/*"
                                                            name="images[]" multiple onchange="handleFileSelect(event)" />
                                                    </div>
                                                </div>


                                                <div id="image-previews-container">
                                                    <?php
                                                        $z = 0;
                                                    ?>
                                                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $z++;
                                                        ?>
                                                        <div class="image-show existing-image" data-id="<?php echo e($image->id); ?>">
                                                            <div class="img-details">
                                                                <ul class="nav">
                                                                    <li class="nav-item">
                                                                        <div class="uploaded-image">
                                                                            <img src="<?php echo e(asset('storage/' . $image->file)); ?>"
                                                                                alt="Uploaded Image" />
                                                                        </div>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <div class="product-name"><?php echo e($image->name); ?></div>
                                                                        <div class="product-size">File Size</div>
                                                                        <a class="btn btn-primary btn-sm mt-1 rename-btn"
                                                                            href="#title-modal" data-bs-toggle="modal"
                                                                            data-id="<?php echo e($image->id); ?>">
                                                                            <i class='bx bxs-edit-alt me-1'></i> Rename
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="progress" style="height: 2px;">
                                                                <div class="progress-bar" role="progressbar"
                                                                    style="width: 100%;" aria-valuenow="100"
                                                                    aria-valuemin="0" aria-valuemax="100"></div>
                                                            </div>
                                                            <div class="close-sec">
                                                                <button class="close-btn" type="button"
                                                                    data-id="<?php echo e($image->id); ?>">X</button>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>

                                                <input type="hidden" id="removed-images" name="removed_images"
                                                    value="">


                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row py-2">
                                        <input type="hidden" name="isdraft" value="">
                                        <div class="col-12 text-md-end">
                                            <a href="<?php echo e(route('events.show', $booth->event->id)); ?>" type="reset"
                                                class="btn btn-lg btn-dark me-md-2">Cancel</a>
                                            <button type="button" id="draftBtn" class="btn btn-dark btn-lg me-md-2"
                                                name="draft">
                                                Save Draft
                                            </button>
                                            <button type="button" id="submitBtn" class="btn btn-primary btn-lg"
                                                data-bs-toggle = "modal" data-bs-target = "#successModal">
                                                Submit
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>

                </div>
            <?php endif; ?>
        <?php else: ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-rating')): ?>
                <div class = "dashboard-body">

                    <div class="row">

                        <div class="col-12 mb-2">
                            <div class="card">
                                <div class="card-header border-bottom">
                                    <div class="booth-detail-header">
                                        <div class="row align-items-center justify-content-between">
                                            <div class="col-sm-6 mb-3 mb-sm-0">
                                                <div class="exb-name">
                                                    <h6 class = "mb-2">Exhibitor Name</h6>
                                                    <h4><?php echo e($booth->exhibitor_name); ?></h4>
                                                </div>
                                                <div class="booth-rating">
                                                    <div class="result-icon bronze d-flex align-items-center">
                                                        <h3 class = "mb-0 d-flex align-items-center">
                                                            <?php if($submitted && $draft): ?>
                                                                <span>
                                                                    N/A
                                                                </span>
                                                            <?php elseif($rating == 'Bronze'): ?>
                                                                <img src="<?php echo e(asset('assets/images/elements/Bronze-star.svg')); ?>"alt="Credit Card"
                                                                    class = "me-2" width = "40" height = "auto" />
                                                                <span>
                                                                    Bronze
                                                                </span>
                                                            <?php elseif($rating == 'Gold'): ?>
                                                                <img src="<?php echo e(asset('assets/images/elements/Gold-star.svg')); ?>"alt="Credit Card"
                                                                    class = "me-2" width = "40" height = "auto" />
                                                                <span>
                                                                    Gold
                                                                </span>
                                                            <?php elseif($rating == 'Silver'): ?>
                                                                <img src="<?php echo e(asset('assets/images/elements/Silver-star.svg')); ?>"alt="Credit Card"
                                                                    class = "me-2" width = "40" height = "auto" />
                                                                <span>
                                                                    SILVER
                                                                </span>
                                                            <?php elseif($rating == 'Disposable'): ?>
                                                                <span>
                                                                    Disposable
                                                                </span>
                                                            <?php else: ?>
                                                                <span>
                                                                    N/A
                                                                </span>
                                                            <?php endif; ?>


                                                        </h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 text-sm-end">
                                                <div class="booth-num mb-2">
                                                    Stand Number: <span class="ms-2"><?php echo e($booth->number); ?></span>
                                                </div>
                                                <div class="booth-size mb-2">
                                                    Stand Size m<sup>2</sup>: <span class="ms-2"><?php echo e($booth->size); ?></span>
                                                </div>
                                                <div class="reating-by">
                                                    Stand assessment by: <span
                                                        class="ms-2"><?php echo e($assessmentByUser); ?></span>
                                                </div>
                                                <?php if(!$booth->draft && (Auth::user()->hasRole('Admin') || Auth::user()->hasRole('Super Admin'))): ?>

                                                              <div class="dropdown">
            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
            data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bx bx-dots-vertical-rounded"></i>
            </button>
            <div class="dropdown-menu" style="">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('event-edit')): ?>


            <a href="<?php echo e(route('booth.allowEdit', $booth->id)); ?>" class="dropdown-item" onclick="return confirm('Only user can edit stand. Please confirm')">
                                                            <i
            class="bx bx-edit-alt me-1"></i>Edit stand by User
                                                        </a>

                                                        <a href="<?php echo e(route('booth.allowAdminEdit', $booth->id)); ?>" class="dropdown-item" onclick="return confirm('Only Admins can edit stand. Please confirm')">
                                                            <i
            class="bx bx-edit-alt me-1"></i>Edit stand by Admin
                                                        </a>

            <?php endif; ?>

            </div>
            </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if(session()->has('success')): ?>
                                    <div class="alert alert-success">
                                        <?php echo e(session('success')); ?>

                                    </div>
                                <?php elseif(session()->has('failed')): ?>
                                    <div class="alert alert-danger">Some Error Occured!</div>
                                <?php endif; ?>
                                <div
                                    class="table-responsive booth-d-table <?php if($draft && $submitted): ?> <?php echo e('d-none'); ?> <?php endif; ?>">
                                    <table class="table table-hover ">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>
                                                    Criteria
                                                </th>
                                                <th>
                                                    Feedback
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody class="table-border-bottom-0">
                                            <?php
                                                $index = 0;
                                            ?>
                                            <?php $__currentLoopData = $booth->rating; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $index++;
                                                ?>
                                                <tr>
                                                    <td><?php echo e($index); ?>.</td>
                                                    <td>
                                                        <?php echo e($rating->question->name); ?>

                                                    </td>
                                                    <td>
                                                        <?php if($rating->result == 'yes'): ?>
                                                            <span class="badge bg-success">YES</span>
                                                        <?php elseif($rating->result == 'no'): ?>
                                                            <span class="badge bg-danger">NO</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-secondary">N/A</span>
                                                        <?php endif; ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                            



                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                        <?php if($comment!=null && !$draft): ?>
                        <div class="col-12 mb-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="mb-0 text-black">Comments</h4>
                                </div>
                                <div class="card-body">
                                    <h5><?php echo e($comment->comment); ?></h5>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="col-12 mb-4 <?php if($draft && $submitted): ?> <?php echo e('d-none'); ?> <?php endif; ?>">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="mb-0 text-black">Stands Pictures</h4>
                                </div>
                                <div class="card-body">
                                    <section class="photo-gallery">
                                        <div class="container px-0">
                                            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 gallery-grid">
                                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col">
                                                        <a class="gallery-item" href="<?php echo e(asset('storage/' . $image->file)); ?>">
                                                            <img src="<?php echo e(asset('storage/' . $image->file)); ?>"
                                                                class="img-fluid" alt="<?php echo e($image->name); ?>">
                                                            <div class="img-title text-center">
                                                                <?php echo e($image->name); ?>

                                                            </div>
                                                        </a>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                            </div>
                                        </div>
                                    </section>
                                </div>
                            </div>
                        </div>

                        
                        <div class = "col-12 mb-4 d-none">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="mb-0 text-black">Stands Pictures</h4>
                                </div>
                                <div class="card-body">
                                    <section class = "ph-gallery">

                                        <div class = "container px-0">

                                            <div id="gallery" class="grid flex gallery"></div>
                                            <template id="template-card">
                                                <figure class="gallery__figure">
                                                    <img class="gallery__img" height="300" loading="lazy"
                                                        width="300" />
                                                </figure>
                                            </template>

                                        </div>

                                    </section>
                                </div>

                            </div>
                        </div>

                    </div>

                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>

    <script>
    var ratingCat = '';
    let criteriaSelections = {};
    let existingFiles = [];
    let removedImageIds = new Set();
    let imageNameMap = {}; // To keep track of renamed images

    const existingImages = <?php echo json_encode($images, 15, 512) ?>; // Pass existing images from PHP to JS
        const MAX_FILE_SIZE = 5 * 1024 * 1024; // 10MB in bytes
    window.addEventListener('scroll', function() {
        var header = document.getElementById('stickyHeader');
        var headerOffset = header.offsetTop;
        var scrollPosition = window.scrollY;
        var threshold = window.innerWidth < 767 ? 450 : 200; // Adjust threshold for mobile screens

        if (scrollPosition >= headerOffset + threshold) {
            header.classList.add('sticky');
        } else {
            header.classList.remove('sticky');
        }
    });

    function removeStoredImage(id) {
        const imageContainer = document.querySelector(`.existing-image[data-id="${id}"]`);
        if (imageContainer) {
            imageContainer.remove();
            removedImageIds.add(id);

            // Update hidden field with removed image IDs
            const removedImagesField = document.getElementById('removed-images');
            removedImagesField.value = Array.from(removedImageIds).join(',');
        }
    }

    document.addEventListener('DOMContentLoaded', () => {
        const MAX_FILES = 10;

        function handleFileSelect(event) {
        const newFiles = Array.from(event.target.files);
        const validFiles = [];
            if (existingFiles.length + newFiles.length > MAX_FILES) {
                alert(`You can only upload a maximum of ${MAX_FILES} images.`);
            return; // Exit the function if limit exceeded
        }
        for (const file of newFiles) {
            if (file.size <= MAX_FILE_SIZE) {
                validFiles.push(file);
            } else {
                alert(`File ${file.name} exceeds the ${MAX_FILE_SIZE/(1024*1024)}MB size limit and will not be uploaded.`);

            }
        }

        existingFiles = existingFiles.concat(validFiles);
        renderPreviews();
    }

        function renderPreviews() {
            const container = document.getElementById('image-previews-container');
            container.innerHTML = ''; // Clear the container before re-rendering

            // Render existing images
            existingImages.forEach((image, index) => {
                if (!removedImageIds.has(image.id)) {
                    const previewDiv = document.createElement('div');
                    previewDiv.classList.add('image-show', 'existing-image');
                    previewDiv.setAttribute('data-id', image.id);
                    previewDiv.innerHTML = `
                        <div class="img-details">
                            <ul class="nav">
                                <li class="nav-item">
                                    <div class="uploaded-image">
                                        <img src="<?php echo e(asset('storage/')); ?>/${image.file}" alt="Uploaded Image" />
                                    </div>
                                </li>
                                <li class="nav-item">
                                    <div class="product-name">${imageNameMap[image.id] || image.name}</div>
                                    <div class="product-size">File Size</div>
                                    <a class="btn btn-primary btn-sm mt-1 rename-btn" href="#title-modal" data-bs-toggle="modal" data-id="${image.id}">
                                        <i class='bx bxs-edit-alt me-1'></i> Rename
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="progress" style="height: 2px;">
                            <div class="progress-bar" role="progressbar" style="width: 100%;" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <div class="close-sec">
                            <button class="close-btn" type="button" data-id="${image.id}">X</button>
                        </div>
                    `;
                    container.appendChild(previewDiv);

                    // Add event listener for the remove button
                    previewDiv.querySelector('.close-btn').addEventListener('click', function() {
                        removeStoredImage(image.id);
                    });

                    // Add event listener for the rename button
                    previewDiv.querySelector('.rename-btn').addEventListener('click', function() {
                        const id = this.getAttribute('data-id');
                        document.getElementById('nameBasic').value = imageNameMap[id] || image.name;
                        document.getElementById('nameBasic').setAttribute('data-id', id);
                    });
                }
            });

            // Render new images
            existingFiles.forEach((file, index) => {
                const reader = new FileReader();
                reader.onload = function() {
                    const previewDiv = document.createElement('div');
                    previewDiv.classList.add('image-show');
                    previewDiv.setAttribute('data-index', index);
                    previewDiv.innerHTML = `
                        <div class="img-details">
                            <ul class="nav">
                                <li class="nav-item">
                                    <div class="uploaded-image">
                                        <img src="${reader.result}" alt="Uploaded Image" />
                                    </div>
                                </li>
                                <li class="nav-item">
                                    <div class="product-name">${file.name}</div>
                                    <div class="product-size">${(file.size / 1024).toFixed(2)} KB</div>
                                    <a class="btn btn-primary btn-sm mt-1 rename-btn" href="#title-modal" data-bs-toggle="modal" data-index="${index}">
                                        <i class='bx bxs-edit-alt me-1'></i> Rename
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="progress" style="height: 2px;">
                            <div class="progress-bar" role="progressbar" style="width: 100%;" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <div class="close-sec">
                            <button class="close-btn" type="button" data-index="${index}">X</button>
                        </div>
                    `;
                    container.appendChild(previewDiv);

                    // Add event listener for the remove button
                    previewDiv.querySelector('.close-btn').addEventListener('click', function() {
                        removeFile(index);
                    });

                    // Add event listener for the rename button
                    previewDiv.querySelector('.rename-btn').addEventListener('click', function() {
                        const index = this.getAttribute('data-index');
                        const file = existingFiles[index];
                        document.getElementById('nameBasic').value = file.name;
                        document.getElementById('nameBasic').setAttribute('data-index', index);
                    });
                };
                reader.readAsDataURL(file);
            });
        }

        function removeFile(index) {
            existingFiles.splice(index, 1);
            renderPreviews();
        }

        // Handle renaming the file
        document.getElementById('save-rename').addEventListener('click', () => {
            const newName = document.getElementById('nameBasic').value;
            const index = document.getElementById('nameBasic').getAttribute('data-index');
            const id = document.getElementById('nameBasic').getAttribute('data-id');

            if (id) {
                // Update the display name in the preview for existing files
                const targetDiv = document.querySelector(`.existing-image[data-id="${id}"]`);
                targetDiv.querySelector('.product-name').textContent = newName;
                imageNameMap[id] = newName;

                // Add a hidden field to store the renamed file name
                let hiddenField = document.querySelector(`input[name="image-names[${id}]"]`);
                if (!hiddenField) {
                    hiddenField = document.createElement('input');
                    hiddenField.type = 'hidden';
                    hiddenField.name = `image-names[${id}]`;
                    hiddenField.value = newName;
                    document.getElementById('image-previews-container').appendChild(hiddenField);
                } else {
                    hiddenField.value = newName;
                }
            } else if (index !== null) {
                // Update the display name in the preview for new files
                const targetDiv = document.querySelector(`.image-show[data-index="${index}"]`);
                targetDiv.querySelector('.product-name').textContent = newName;
                existingFiles[index].name = newName; // Also update the file name in the existingFiles array

                // Add a hidden field to store the renamed file name for new files
                let hiddenField = document.querySelector(`input[name="new-image-names[${index}]"]`);
                if (!hiddenField) {
                    hiddenField = document.createElement('input');
                    hiddenField.type = 'hidden';
                    hiddenField.name = `new-image-names[${index}]`;
                    hiddenField.value = newName;
                    document.getElementById('image-previews-container').appendChild(hiddenField);
                } else {
                    hiddenField.value = newName;
                }
            }

            // Close the modal
            const modalElement = document.getElementById('title-modal');
            const modalInstance = bootstrap.Modal.getInstance(modalElement);
            modalInstance.hide();
        });

        // Bind the file select handler
        document.getElementById('upload-img-pu').addEventListener('change', handleFileSelect);

        // Initialize the previews on page load
        renderPreviews();
    });

    const saveDraftBtn = document.querySelector('#draftBtn'); // Target the Save Draft button
    const submitBtn = document.querySelector('#submitBtn'); // Target the Submit button

    saveDraftBtn.addEventListener('click', () => {
        document.querySelector('input[name="isdraft"]').value = '1';
        const fileInput = document.getElementById('upload-img-pu');
        fileInput.files = dataTransferFromFiles(existingFiles);

        // Create a hidden input to pass removed image IDs
        const form = document.getElementById('ratingForm');
        let removedInput = document.getElementById('removedImageIds');
        if (!removedInput) {
            removedInput = document.createElement('input');
            removedInput.type = 'hidden';
            removedInput.name = 'removedImageIds';
            removedInput.id = 'removedImageIds';
            form.appendChild(removedInput);
        }
        removedInput.value = Array.from(removedImageIds).join(',');

        let allSelected = true;
        for (const key in criteriaSelections) {
            if (criteriaSelections[key] === "") {
                allSelected = false;
                break;
            }
        }
        $("#ratingForm").submit();
    });

    submitBtn.addEventListener('click', () => {
        document.querySelector('input[name="isdraft"]').value = '0';
        const fileInput = document.getElementById('upload-img-pu');
        fileInput.files = dataTransferFromFiles(existingFiles);

        // Create a hidden input to pass removed image IDs
        const form = document.getElementById('ratingForm');
        let removedInput = document.getElementById('removedImageIds');
        if (!removedInput) {
            removedInput = document.createElement('input');
            removedInput.type = 'hidden';
            removedInput.name = 'removedImageIds';
            removedInput.id = 'removedImageIds';
            form.appendChild(removedInput);
        }
        removedInput.value = Array.from(removedImageIds).join(',');

        let allSelected = true;
        for (const key in criteriaSelections) {
            if (criteriaSelections[key] === "") {
                allSelected = false;
                break;
            }
        }
        if (ratingCat == 'NOT' || !allSelected) {
            alert("Please Fill Form Correctly before saving");
        } else {
            $("#ratingForm").submit();
        }
    });

    const draft = <?php echo json_encode($draft, 15, 512) ?>|| <?php echo json_encode($adminEdit, 15, 512) ?>;

    if (draft) {
        const questions = <?php echo json_encode($questions, 15, 512) ?>;
        questions.forEach(question => {
            criteriaSelections[question.slug] = question.rating ? question.rating.result : '';
        });
    } else {
        <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            var slug = "<?php echo e($question->slug); ?>";
            criteriaSelections[slug] = '';
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    }

    console.log(criteriaSelections);

    function dataTransferFromFiles(files) {
        const dataTransfer = new DataTransfer();
        files.forEach(file => dataTransfer.items.add(file));
        return dataTransfer.files;
    }

    function handleRadioChange(event, slug) {
        criteriaSelections[slug] = event.target.value;
        console.log(criteriaSelections);
        var url = "<?php echo e(route('booth.rating')); ?>";
        var method = 'post';
        var dataType = null;
        var parameters = {
            ratings: criteriaSelections
        };

        requestAjax(url, method, dataType, parameters)
            .then(response => {
                ratingCat = response[0];
                console.log(ratingCat.toLowerCase());
                $("#ratingCategory").removeClass();

                $("#ratingCategory").addClass('rating-badge');
                $("#ratingCategory").addClass(response[0].toLowerCase());
            })
            .catch(error => {
                console.error(error); // Handle errors (e.g., display error messages)
            });
    }
</script>



    <!-- / Content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade" id="title-modal" tabindex="-1" aria-labelledby="titleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="titleModalLabel">Rename Image</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="text" id="nameBasic" class="form-control" placeholder="Enter new name">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="save-rename">Save changes</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8\htdocs\Booth-management\resources\views/admin/events/booth-detail.blade.php ENDPATH**/ ?>