<!DOCTYPE html>
<html>
<head>
    <title>Account Created</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border: 1px solid #dddddd;
            border-radius: 5px;
            overflow: hidden;
        }
        .header {
            background-color: #007bff;
            padding: 20px;
            text-align: center;
        }
        .header img {
            max-width: 100%;
            height: auto;
        }
        .content {
            padding: 20px;
            color: #333333;
        }
        .footer {
            background-color: #f4f4f4;
            padding: 10px;
            text-align: center;
            font-size: 12px;
            color: #999999;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('assets/images/logos/BLG-dark-logo.png'))) }}" style="width: 300px;" alt="Company Logo">
        </div>
        <div class="content">
            <h1>Welcome, {{ $user->name }}!</h1>
            <p>Your account has been created. Here are your login details:</p>
            <p>Email: {{ $user->email }}</p>
            <p>Password: {{ $password }}</p>
            <p>Thank you!</p>
        </div>
        <div class="footer">
            <p>&copy; {{ date('Y') }} BLG. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
