@extends('layouts.auth')

@section('content')
<!-- Logo -->
                            <div class="app-brand justify-content-center">
                                <a href="index.php" class="app-brand-link gap-2">
                                    <span class="app-brand-logo demo">
                                        <img src="assets/images/logos/BLG-dark-logo.png" alt="BLG-logo">
                                    </span>
                                </a>
                            </div>
                            <!-- /Logo -->
    <p class="text-center">Sign in</p>


    <form id="formAuthentication" class="mb-3" action="{{ route('login') }}" method = "post">
        @csrf
        <div class="form-group">
            <label for="email" class="form-label">Email</label>
            <input type="text" class="form-control" id="email" name="email" value="{{ old('email') }}"
                placeholder="Enter your email" autofocus />
            @error('email')
                <div class="form-error">
                    {{ $message }}
                </div>
            @enderror
        </div>
        <div class="form-group form-password-toggle">
            <label class="form-label" for="password">Password</label>
            <div class="input-group input-group-merge">
                <input type="password" id="password" class="form-control @error('password') is-invalid @enderror"
                    name="password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                    aria-describedby="password" />
                <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>

            </div>
            @error('password')
                    <div class="form-error">
                        <strong>{{ $message }}</strong>
                    </div>
                @enderror
        </div>
        <div class="form-group">
            <div class="d-flex justify-content-between flex-wrap">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="remember" id="remember"
                        {{ old('remember') ? 'checked' : '' }} />
                    <label class="form-check-label me-3 me-sm-0" for="remember-me"> Remember Me </label>
                </div>
                <a href="{{ route('password.request') }}" class = "d-none d-md-block">
                    <small>Forgot Password?</small>
                </a>
            </div>
        </div>
        <div class="form-group">
            <button class="btn btn-primary d-grid w-100" type="submit">Sign in</button>
        </div>
        <div class="form-group my-3 text-center d-md-none">
            <a href="{{ route('password.request') }}">
                <small>Forgot Password?</small>
            </a>
        </div>
    </form>
@endsection
