@extends('layouts.app')
@php
    $currentPage = 'add-events';
@endphp
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class = "dashboard-body">
            <div class="row">
                <div class="col-md-12 col-lg-8 col-xl-7">
                    <div class="card mb-2">
                        <div class="card-body overflow-hidden">

                            @if (session()->has('failed'))
                                <div class="alert alert-danger">{{ session('failed') }}</div>
                            @endif
                            <form action="{{ route('events.store') }}" id="registrationForm" method="post">
                                @csrf
                                <div class="mb-3">
                                    <label for="eventTitle" class="form-label">Event Title</label>
                                    <input type="text" class="form-control" name="name" id="eventTitle"
                                        placeholder="Name">
                                    <div id="eventTitleError" class="form-error mt-1">
                                        @error('name')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="row">
                                        <div class="col-md-6 mb-3 mb-md-0">
                                            <label for="eventstartdate" class="form-label">Event Start Date</label>
                                            <input class="form-control" name="start_at" type="date"
                                                value="{{ date('Y-m-d') }}" id="start_date" onchange="setMinDates(event)">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="eventenddate" class="form-label">Event End Date</label>
                                            <input class="form-control" name="end_at" type="date"
                                                value="{{ date('Y-m-d') }}" id="end_date" onchange="setMaxDates(event)">
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="eventInfo" class="form-label">Event Info</label>
                                    <textarea class="form-control" name="info" id="eventInfo" rows="3"></textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="userSelect" class = "form-label">Number of Halls</label>
                                    <select id="userSelect"
                                        class="form-select usertype-select wide @if ($errors->has('num_halls')) {{ 'mb-2' }} @else {{ 'mb-4' }} @endif"
                                        name="num_halls">
                                        <option value="" selected disabled>Select Hall</option>
                                        @for ($number = 1; $number <= 50; $number++)
                                            <option value="{{ $number }}">{{ $number }}</option>
                                        @endfor
                                    </select>
                                    <div id="userSelectError" class="form-error mt-1">
                                        @error('num_halls')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>



                                <div class="mb-3">
                                    <label for="exampleFormControlSelect2" class="form-label">Assign User</label>
                                    <select multiple="" class="form-select multiselect-events "
                                        id="exampleFormControlSelect2" aria-label="Multiple select example"
                                        name="user_ids[]" multiple="multiple">
                                        <option value="" disabled>Select user</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}">
                                                {{ $user->name . '(' . $user->getRoleNames()->first() . ')' }}</option>
                                        @endforeach
                                    </select>
                                    <div id="exampleFormControlSelect2Error" class="form-error mt-1">
                                        @error('user')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 mt-4">
                                    <div class="row">
                                        <div class="col-12 text-end">
                                            <a href = "{{ route('events.index') }}" type="reset"
                                                class="btn btn-outline-secondary me-2">Cancel</a>
                                            <button type="submit" class="btn btn-primary">
                                                Add Event
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>
    <!-- / Content -->


    <script>
        let endDate_set = false;
        let startDate_set = false;

        function setMinDates(event) {
            startDate_set = true;
            $("#end_date").attr('min', event.target.value);
            (!endDate_set) ? $("#end_date").val(event.target.value): "";
        }

        function setMaxDates(event) {
            endDate_set = true;
            $("#start_date").attr('max', event.target.value);
            //(!startDate_set)?$("#start_date").val(event.target.value):'';
        }
        // Get today's date
        var today = new Date().toISOString().split('T')[0];
        //     var start_date=$("#start_date").val();
        //     console.log(start_date);
        $("#end_date").attr('min', today);
        // Set the minimum date of the input to today
        //document.getElementById("html5-date-input").min = today;

        $(document).ready(function() {



            $('#registrationForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true,
                    },
                    num_halls: {
                        required: true,
                    },
                    'user_ids[]': { // Use quotes since the field name contains brackets
                        required: true, // Require at least one option to be selected
                    }
                },
                messages: {
                    name: {
                        required: "Please provide your full name",
                    },
                    num_halls: {
                        required: "Please Select a hall",
                    },
                    'user_ids[]': { // Use quotes since the field name contains brackets
                        required: "Please select at least one user", // Custom message for multiple select
                    }
                },
                errorPlacement: function(error, element) {
                    var errorElementId = element.attr('id') + 'Error';
                    if (element.attr('id') == 'userSelect') {
                        $(".usertype-select").removeClass('mb-4');
                        $(".usertype-select").addClass('mb-2');
                    }
                    $('#' + errorElementId).text(error.text());
                },
                highlight: function(element, errorClass, validClass) {
                    var value = $(element).val();
                    // Add your highlighting logic if needed
                },
                unhighlight: function(element, errorClass, validClass) {
                    var errorElementId = $(element).attr('id') + 'Error';
                    $('#' + errorElementId).empty();
                },
                submitHandler: function(form) {
                    form.submit();
                }
            });

        });
    </script>
@endsection
