<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Permission;
use Exception;
use Illuminate\Support\Facades\Log;

class RoleController extends Controller
{
    function __construct()
    {
        $this->middleware('role:Super Admin', ['only' => ['index', 'store']]);


    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $permissions=Permission::all();
        $roles=Role::where('name','!=' , 'Super Admin')->get();
        return view('admin.roles.index',['permissions'=>$permissions,'roles'=>$roles]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $roles=Role::where('name','!=','Super Admin')->get();
            foreach($roles as $role){
                $role->syncPermissions([]);
            }
            $roles = $request->except('_token');
            //return $roles;
            foreach ($roles as $key => $value) {

                $role = Role::find($key);
                $role->syncPermissions($value);
            }
            return redirect()->back()->with('success', 'Permissions assigned Successfully');
        }catch(Exception $ex){
            Log::info("Error on role controller". $ex->getMessage());
            return  back()->withInput()->withErrors(['failed' => 'Failed while assigning permissions']);
        }


    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
