<?php
    $currentPage = 'view-events';
    $eventName = $event->name;
    $count = $count;

?>
<?php $__env->startSection('content'); ?>
    <?php
        use Carbon\Carbon;

    ?>
    <style>
        table td{
            text-wrap: pretty;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class = "dashboard-body">
            <div class="row">

                <!-- Booths Statistics -->
                <div class="col-md-12 mb-2">
                    <div class="card h-100 total-events-card">
                        <div class="card-body">

                            <div class="card-header d-flex align-items-center justify-content-between px-0 pt-0">
                                <div class="card-title mb-0 d-flex justify-content-between w-100 align-items-center">
                                    <div class="title-info">
                                        <h1 class="m-0 me-2"><?php echo e($event->name); ?></h1>
                                    </div>

                                    <?php if(auth()->user()->can('event-edit') || auth()->user()->can('delete-event')): ?>

                        <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                        </button>
                                <div class="dropdown-menu" style="">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('event-edit')): ?>
                                <a class="dropdown-item" href="<?php echo e(route('events.edit', $event->id)); ?>"><i
                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-event')): ?>
                                            <form action="<?php echo e(route('events.destroy',$event->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="_method" value="DELETE">
                                                <button type="submit" onclick="return confirm('Are you sure you want to delete event?')" class="dropdown-item">

                                                <i class="bx bx-trash me-1"></i>

                                                Delete</button>
                                            </form>
                                <?php endif; ?>
                                </div>
                        </div>
                                    <?php endif; ?>
                                </div>

                            </div>



                            <div class="row align-item-center justify-content-between">
                                <div class="col-12">
                                    <div><?php echo e(Carbon::parse($event->start_at)->format('d-M-Y')); ?> To
                                        <?php echo e(Carbon::parse($event->end_at)->format('d-M-Y')); ?></div>
                                </div>
                                <div class="col-12">
                                    <ul class="p-0 m-0 mt-2">
                                        <li class="d-flex">
                                            <div class="me-1 d-block d-lg-flex mb-3 mb-lg-0 align-items-center gap-3">
                                                <div class = "assign-title">Assigned To:</div>
                                                <?php if($event->users->isNotEmpty()): ?>
                                                    <ul class = "user-list nav align-items-center gap-2">
                                                        <?php $__currentLoopData = $event->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class = "nav-item">
                                                                <div class = "user-badge d-flex align-items-center gap-1">
                                                                    <i class = "bx bxs-user-circle"></i>
                                                                    <span><?php echo e($user->name); ?></span>
                                                                </div>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                    </ul>
                                                <?php else: ?>
                                                    No users assigned.
                                                <?php endif; ?>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class = "col-md-6 mb-2 d-none">
                    <div class="card h-100 total-events-card">
                        <div class="card-body">

                            <div class="card-header d-flex align-items-center justify-content-between px-0 pt-0">
                                <div class="card-title mb-0 d-flex justify-content-between w-100 align-items-center">
                                    <div class="title-info">
                                        <h1 class="m-0 me-2 mb-0"><?php echo e($event->name); ?></h1>
                                    </div>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('event-edit')): ?>
                                        <div class = "edit-side">
                                            <div class="edit-btn">
                                                <a href="<?php echo e(route('events.edit', $event->id)); ?>"
                                                    class="btn btn-icon btn-outline-secondary">
                                                    <span class="tf-icons bx bx-edit"></span>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                            </div>

                            <div class="row align-item-center justify-content-between">
                                <div class="col-12">
                                    <div><?php echo e(Carbon::parse($event->start_at)->format('d-M-Y')); ?> To
                                        <?php echo e(Carbon::parse($event->end_at)->format('d-M-Y')); ?></div>
                                </div>
                                <div class="col-12">
                                    <ul class="p-0 m-0 mt-2">
                                        <li class="d-flex">
                                            <div class="me-1">
                                                Assigned To:
                                                <?php if($event->users->isNotEmpty()): ?>
                                                    <?php $__currentLoopData = $event->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e($user->name); ?><?php if(!$loop->last): ?>
                                                            ,
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    No users assigned.
                                                <?php endif; ?>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class = "col-md-6 mb-2 d-none">
                    <div class="card event-card h-100">
                        <div class="card-body">
                            <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                <div class="card-result d-flex w-100 justify-content-between">
                                    <span class = "mb-2">Total number of Stands</span>
                                    <h5 class="card-title text-nowrap mb-1"><?php echo e($total_booths); ?></h5>
                                </div>
                                <div class="card-result d-flex w-100 justify-content-between">
                                    <span class="mb-2">Net m<sup>2</sup> of all Stands</span>
                                    <h5 class="card-title text-nowrap mb-1"><?php echo e($total_size); ?></h5>
                                </div>
                                <div class="card-result d-flex w-100 justify-content-between">
                                    <span class = "mb-2">Stands that are disposable</span>
                                    <h5 class="card-title text-nowrap mb-1"></h5>
                                </div>
                                <div class="card-result d-flex w-100 justify-content-between">
                                    <span class="mb-2">m<sup>2</sup> of Stands that are disposable</span>
                                    <h5 class="card-title text-nowrap mb-1"></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 d-none">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                            <div class="card event-card h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                            <span class = "mb-2">Total number of Stands</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($total_booths); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                            <div class="card event-card h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                            <span class = "mb-2">Net m<sup>2</sup> of all Stands</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($total_size); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                            <div class="card event-card h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                            <span class = "mb-2">Stands that are disposable</span>
                                            <h3 class="card-title text-nowrap mb-1"></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                            <div class="card event-card h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                            <span class = "mb-2">m<sup>2</sup> of Stands that are disposable</span>
                                            <h3 class="card-title text-nowrap mb-1"></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6 col-lg-3 mb-2">
                            <div class="card event-card total-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>Total Stands</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($total_booths); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-lg-3 mb-2">
                            <div class="card event-card complete-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>Net m<sup>2</sup> of all Stands</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($total_size); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-lg-3 mb-2">
                            <div class="card event-card inprogress-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>Stands that are disposable</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($stats['disposableBoothsCount']); ?>

                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-lg-3 mb-2">
                            <div class="card event-card inprogress-event h-100">
                                <div class="card-body">
                                    <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                        <div class="card-result">
                                            <span>m<sup>2</sup> of Stands that are disposable</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo e($stats['disposableBoothsSize']); ?>

                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <!--/ Booths Statistics -->

                <div class = "col-12">
                    <div class="card p-0 mb-2">
                        <div class="card-body d-flex flex-column flex-md-row justify-content-between p-0">
                            <div class="row card-body align-items-md-center text-md-center justify-content-center">
                                <div class = "col-lg-8 col-xl-6">
                                    <h3 class="card-title mb-2 lh-sm px-md-5 text-center text-black">
                                        Search
                                    </h3>
                                    <p class="mb-4 text-center text-black">
                                        Search Stand by Code or Name
                                    </p>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <input type="search" id="searchStand" placeholder="Search Stand by Code or Name"
                                            class="form-control me-2" oninput="searchBooth(this.value)">
                                        <button type="submit" class="btn btn-primary btn-icon"><i
                                                class="bx bx-search-alt"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 mb-2">
                    <div class="card">
                        <div class="card search-card m-3 shadow-none d-none">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-8 col-md-9 mb-3 mb-sm-0">
                                        <div class="form-group">
                                            <input type="text" class="form-control" id="searchStand"
                                                placeholder="Search Stand by Code or Name"
                                                oninput="searchBooth(this.value)">
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="form-group">
                                            <button type="button" class="btn btn-dark w-100">
                                                <span class="tf-icons bx bx-search-alt me-1"></span> Search
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-header border-bottom">
                            <div class="b-table-header">
                                <div class="row pb-2 booth-title justify-content-between mb-3">
                                    <?php if(session()->has('successHall')): ?>
                                        <div class="alert alert-success">
                                            <?php echo e(session()->get('successHall')); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="col-md-4">
                                        <select id="hallSelect"
                                            class="form-select usertype-select wide mb-3 mb-md-0 userTypeHall"
                                            id="selectHall" onchange="searchByHall(this)">
                                            <option value="0">All</option>
                                            <?php $__currentLoopData = $halls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hall): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($hall->id); ?>"><?php echo e($hall->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-8 text-md-end">

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('generate-stands-report')): ?>
                                        <a href="<?php echo e(route('booths.export', $event->id)); ?>">
                                            <button class="btn btn-outline-primary me-2 mb-2 mb-md-0 btn-full-sm">
                                                <i class="bx bxs-download me-1"></i> Generate Report
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->hasRole('Super Admin') || auth()->user()->hasRole('Admin')): ?>
                                        <button data-bs-toggle="modal" data-bs-target="#import__Stand"
                                            class="btn btn-secondary add-new btn-primary mb-2 mb-md-0 btn-full-sm"
                                            type="button">
                                            <span>
                                                <i class="bx bx-export me-1"></i>
                                                <span>Import Stands</span>
                                            </span>
                                        </button>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('booth-create')): ?>
                                            <button data-bs-toggle="modal" data-bs-target="#addBoothModal"
                                                class="btn btn-secondary add-new btn-primary mb-2 mb-md-0 btn-full-sm"
                                                type="button">
                                                <span>
                                                    <i class="bx bx-plus me-0 me-sm-1"></i>
                                                    <span>Add Stand</span>
                                                </span>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class = "row pt-md-2 align-items-center">


                                    <div class = "col-12 col-md-6 col-lg-8 col-xxl-9 mb-3 mb-md-0">
                                        <div class="d-flex flex-column">
                                            <div class = "hall-name d-flex align-items-center d-none" id="hallEditArea">
                                                <h5 class = "mb-1" id="hallValue">Hall 1</h5>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('booth-hall-edit')): ?>
                                                    <button class="btn btn-icon p-0 border-0 background-transparent"
                                                        data-bs-toggle = "modal" data-bs-target = "#editHallModal">
                                                        <span class="tf-icons bx bx-edit"></span>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                            <p class = "mb-1 text-muted">Total Stands: <?php echo e($total_booths); ?></p>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-4 col-xxl-3 text-end">
                                        <div class="form-group">
                                            <select id="categorySelect" class="form-select usertype-select wide"
                                                onchange="searchByStand($(this).val())">
                                                <option data-display = "Filter Stands">Nothing</option>
                                                <option value="all">All</option>
                                                <option value="GOLD">Gold</option>
                                                <option value="BRONZE">Bronze</option>
                                                <option value="SILVER">Silver</option>
                                                <option value="DISPOSABLE">Disposible</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                                <div class="row py-3 align-items-center d-none">
                                    <div class = "col-12 col-md-8 mb-3 mb-md-0">
                                        <div
                                            class="d-flex align-items-center justify-content-end justify-content-md-start">
                                            <div class = "hall-name d-flex align-items-center">
                                                <h4 class = "mb-0 ">Hall 1</h4>
                                                <button class="btn btn-icon p-0 border-0 background-transparent"
                                                    data-bs-toggle = "modal" data-bs-target = "#editHallModal">
                                                    <span class="tf-icons bx bx-edit"></span>
                                                </button>
                                            </div>
                                            <h4 class = "mb-0 ms-2 ms-md-4">Total Stands: <?php echo e($total_booths); ?></h4>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-4 text-end">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="search">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="text-nowrap table-responsive user-table booth-table">
                            <?php if(session('boothError')): ?>
                                <div class="alert alert-danger">
                                    <?php echo e(session('boothError')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session()->has('boothErrors')): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = session('boothErrors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                            <table class="table mb-2 table-hover ">
                                <thead>
                                    <tr>
                                        <th>
                                            Stand Number
                                        </th>
                                        <th>
                                            Stand Type
                                        </th>
                                        <th>
                                            Stand Size m<sup>2</sup>
                                        </th>
                                        <th>
                                            Exhibitor Name
                                        </th>
                                        <th>
                                            Result
                                        </th>
                                        <th>
                                            Status
                                        </th>
                                        <th>
                                            Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0" id="boothTableData">

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>






    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const addBoothModal = new bootstrap.Modal(document.getElementById('addBoothModal'));

            // Show modal if there are errors or success message
            <?php if($errors->any() ): ?>
                addBoothModal.show();
            <?php endif; ?>

            // Handle modal close event
            addBoothModal._element.addEventListener('hidden.bs.modal', function() {
                const successMessage = document.getElementById('successMessage');
                const errorMessage = document.getElementById('errorMessage');

                if (successMessage) {
                    successMessage.parentNode.removeChild(successMessage);
                }
                if (errorMessage) {
                    errorMessage.parentNode.removeChild(errorMessage);
                }
            });

            // Handle close button click event
            const closeButton = document.querySelector('#addBoothModal .btn-close');
            if (closeButton) {
                closeButton.addEventListener('click', function() {
                    addBoothModal.hide(); // Manually hide modal on close button click
                });
            }
        });
    </script>

    <script>
        let event_id = '<?php echo e($event->id); ?>';
        $(document).ready(function() {

            var data = <?php echo json_encode($event->booths->toJson()); ?>;
            data = JSON.parse(data);
            console.log(data);
            showBoothData(data, 'boothTableData');

            $.validator.addMethod("noOnlySpaces", function(value, element) {
                return this.optional(element) || $.trim(value).length > 0;
            }, "This field cannot contain only spaces.");
            $.validator.addMethod("validNumber", function(value, element) {
                return this.optional(element) || /^[0-9]+(\.[0-9]+)?$/.test(value);
            }, "Only numbers and decimals are allowed.");

            $.validator.addMethod("noNumbers", function(value, element) {
                return this.optional(element) || !/\d/.test(value);
            }, "Your name cannot contain any numbers.");
            $.validator.addMethod("validPhoneNumber", function(value, element) {
                    // Regex to match valid phone numbers
                    var regex = /^(\+?\d{1,4})?(\d{10,14})$/;
                    return this.optional(element) || regex.test(value);
                },
                "Please enter a valid phone number (11 to 15 digits, optionally starting with a country code).");


            $('#boothreg').validate({
                ignore: [],
                rules: {

                    exhibitor_name: {
                        required: true,
                        noOnlySpaces: true,

                    },
                    hall_id: {
                        required: true
                    },

                    number: {
                        required: true,

                    },
                    stand_type_id: {
                        required: true,
                    },
                    contractor_name: {
                        noNumbers: true,
                    },
                    contractor_phone: {
                        validPhoneNumber: true,
                    },

                    length:{
                        required:true,
                        noOnlySpaces: true,
                        validNumber: true
                    },
                    width:{
                        required:true,
                        noOnlySpaces: true,
                        validNumber: true
                    }




                },
                messages: {


                    exhibitor_name: {
                        required: "Please provide exhibitor's name",
                        noOnlySpaces: "You cannot put only spaces",
                        noNumbers: "Name cannot have any number"

                    },
                    hall_id: {
                        required: "Please Select a Hall",
                    },
                    stand_type_id: {
                        required: "Please Select a stand type",
                    },
                    length:{
                        required:"Please provide length",
                        noOnlySpaces: "You cannot put only spaces in length",
                        validNumber: "Please provide valid number in length"
                    },
                    width:{
                        required:"Please provide width",
                        noOnlySpaces: "You cannot put only spaces in width",
                        validNumber: "Please provide valid number in width"
                    },
                    number: {
                        required: "Please enter stand number"
                    }

                },
                errorPlacement: function(error, element) {
                    var errorElementId = element.attr('id') +
                        'Error'; // Get the ID of the corresponding error message div
                    $('#' + errorElementId).text(error
                        .text()
                    ); // Insert the error message text into the corresponding error message div
                },
                highlight: function(element, errorClass, validClass) {
                    var value = $(element).val();



                },
                unhighlight: function(element, errorClass, validClass) {
                    var errorElementId = $(element).attr('id') + 'Error';
                    $('#' + errorElementId).empty();
                },
                submitHandler: function(form) {
                    form.submit();
                }
            });
             $('#length, #width').on('input', function() {
            updateTotalArea();
        });


        });
        function updateTotalArea() {
            var length = parseFloat($('#length').val());
            var width = parseFloat($('#width').val());

            // Check if length or width are NaN or empty
            if (isNaN(length) || isNaN(width) || length === 0 || width === 0) {
                $('#total_area').text('0 m²');
            } else {
                // Calculate area
                var area = length * width;
                // Update total area display
                $('#total_area').text(area.toFixed(2) + ' m²');
            }
        }

        function searchBooth(value) {
            var hall_id = $("#hallSelect").val();
            var category = $("#categorySelect").val();
            var url = "<?php echo e(route('searchBooth')); ?>";
            var method = 'POST';
            var dataType = "json";
            var parameters = {
                search: value,
                event_id: event_id,
                hall_id: hall_id,
                category: category
            };
            requestAjax(url, method, dataType, parameters)
                .then(response => {
                    console.log(response);
                    showBoothData(response, 'boothTableData');
                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });


        }

        function searchByStand(category) {
            var hall_id = $("#hallSelect").val();
            var search = $("#searchStand").val();
            var url = "<?php echo e(route('searchBoothByStand')); ?>";
            var method = 'POST';
            var dataType = "json";
            var parameters = {
                category: category,
                event_id: event_id,
                hall_id: hall_id,
                search: search
            };
            requestAjax(url, method, dataType, parameters)
                .then(response => {
                    console.log(response);
                    showBoothData(response, 'boothTableData');
                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });
        }

        function searchByHall(selectElement) {
            var selectedOption = selectElement.options[selectElement.selectedIndex];
            var hall_id = selectedOption.value;
            var search = $("#searchStand").val();
            var category = $("#categorySelect").val();
            if (hall_id != '0') {
                $("#hallEditArea").removeClass('d-none');
            } else {
                $("#hallEditArea").addClass('d-none');
            }
            var hall_name = selectedOption.text;
            $("#hallDiv").removeClass('d-none');
            $("#hallValue").html(hall_name);
            $("#hallValueInput").val(hall_name);
            $("#hallIdHidden").val(hall_id);
            var url = "<?php echo e(route('searchBoothByHall')); ?>";
            var method = 'POST';
            var dataType = "json";
            var parameters = {
                hall_id: hall_id,
                event_id: event_id,
                search: search,
                category: category
            };
            requestAjax(url, method, dataType, parameters)
                .then(response => {
                    console.log(response);
                    showBoothData(response, 'boothTableData');
                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });


        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <div class="modal fade" id="addBoothModal" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel1">Add Stand</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('booths.store')); ?>" method="post" id="boothreg">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">


                            <div class="row">
                                <div class="col mb-3">
                                    <label for="exhibitor_name" class="form-label">Exhibitor Name</label>
                                    <input type="text" id="exhibitor_name" class="form-control" name="exhibitor_name"
                                        value="<?php echo e(old('exhibitor_name')); ?>" placeholder="Enter Exhibitor Name">
                                    <div id="exhibitor_nameError" class="form-error mt-1">
                                        <?php $__errorArgs = ['exhibitor_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <input type="hidden" name="event_id" value="<?php echo e($event->id); ?>">
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="number" class="form-label">Stand Number</label>
                                    <input type="text" id="number" class="form-control" name="number"
                                        value="<?php echo e(old('number')); ?>" placeholder="Enter Stand Number">
                                    <div id="numberError" class="form-error mt-1">
                                        <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="nameBasic" class="form-label">Stand Type</label>
                                    <select id="stand_type_id" name="stand_type_id"
                                        class="form-select standtype-select wide mb-3 mb-md-0">
                                        <option selected disabled>Select one</option>
                                        <?php $__currentLoopData = $standTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $standType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($standType->id); ?>"
                                                <?php if(old('stand_type_id') == $standType->id): ?> <?php echo e('selected'); ?> <?php endif; ?>>
                                                <?php echo e($standType->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                    <div id="stand_type_idError" class="form-error mt-1">
                                        <?php $__errorArgs = ['stand_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                            </div>

                            <div class = "row">
                                <div class = "col mb-3">
                                    <label for="nameBasic" class="form-label">Stand Size</label>
                                    <div class="input-group row">
                                    <div class = "col">
                                        <input type="text" value="<?php echo e(old('length')); ?>"  aria-label="First name" id="length" name="length" class="form-control" placeholder="Length (m)">
                                    </div>
                                    <div class = "col">
                                    <input type="text" value="<?php echo e(old('width')); ?>"  aria-label="Last name" id="width" name="width" class="form-control" placeholder="Width (m)">
                                    </div>
                                    <div class = "col">
                                    <span class="input-group-text" id="total_area">00 m<sup>2</sup></span>
                                    </div>
                                    </div>
                                    <div id="lengthError" class="form-error mt-1">
                                        <?php $__errorArgs = ['length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div id="widthError" class="form-error mt-1">
                                        <?php $__errorArgs = ['width'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>






                            <div class="row">
                                <div class="col mb-3">
                                    <label for="contractor_name" class="form-label">Contractor Name</label>
                                    <input type="text" id="contractor_name" class="form-control"
                                        name="contractor_name" value="<?php echo e(old('contractor_name')); ?>"
                                        placeholder="Enter Contractor's name">
                                    <div id="contractor_nameError" class="form-error mt-1">
                                        <?php $__errorArgs = ['contractor_nameError'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="contractor_email" class="form-label">Contractor Email</label>
                                    <input type="text" id="contractor_email" class="form-control"
                                        name="contractor_email" value="<?php echo e(old('contractor_email')); ?>"
                                        placeholder="Enter Contractor's Email">
                                    <div id="contractor_emailError" class="form-error mt-1">
                                        <?php $__errorArgs = ['contractor_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="size" class="form-label">Contractor Phone</label>
                                    <input type="text" id="contractor_phone" class="form-control"
                                        name="contractor_phone" value="<?php echo e(old('contractor_phone')); ?>"
                                        placeholder="Enter Contractor's phone">
                                    <div id="contractor_phoneError" class="form-error mt-1">
                                        <?php $__errorArgs = ['contractor_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="row">

                                <div class="col mb-3">
                                    <label for="hall" class="form-label">Select Hall</label>
                                    <select id="hall" name="hall_id"
                                        class="form-select usertype-select wide mb-3 mb-md-0">
                                        <option value="">Select hall</option>

                                        <?php $__currentLoopData = $halls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hall): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($hall->id); ?>"
                                                <?php if($hall->id == old('hall_id')): ?> <?php echo e('selected'); ?> <?php endif; ?>>
                                                <?php echo e($hall->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="hallError" class="form-error mt-1">
                                        <?php $__errorArgs = ['hall_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>



                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Close
                    </button>
                    <button type="submit" class="btn btn-primary">Add Stand</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Hall Name Modal -->
    <div class="modal fade" id="editHallModal" tabindex="-1" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel1">Edit Hall Name</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('hall.update')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col mb-3">
                                <label for="hallValueInput" class="form-label">Hall Name</label>
                                <input type="text" class="form-control " name="hall_name" id="hallValueInput"
                                    placeholder="Enter Name">
                                <input type="hidden" name="hall_id" id="hallIdHidden">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                        <button type="submit" class="btn btn-primary">Update changes</button>
                </form>
            </div>
        </div>
    </div>
    </div>
    <!-- /Edit Hall Name Modal -->


    <!-- Downlaod and Upload CSV modal -->
	<div class="modal csv_modal fade" id="import__Stand" tabindex="-1" aria-modal="true" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel1">Import Stands</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body border-bottom border-top py-3">
					<div class="row">
						<div class="col mb-3">
							<div class = "download-sec mb-3">
								<p>
									Download the “CSV Template”, fill in the data, and then upload the file to the system.
								</p>
                                <a href="<?php echo e(route('booth.download.sample')); ?>">
                                    <button class = "btn btn-primary">
                                        <i class='bx bxs-download me-2'></i>CSV Template
                                    </button>
                                </a>
							</div>
                            <form id="csvImportForm" action="<?php echo e(route('booths.import')); ?>" style="display:inline"
                                    method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="event_id" value="<?php echo e($event->id); ?>">
							<div class="mb-3">
							  <label for="formFile" class="form-label">Upload CSV</label>
							  <input class="form-control" type="file" name="file" accept=".csv" id="fileInput"  required>
							</div>



						</div>
					</div>
				</div>
				<div class="modal-footer pt-2">
					<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
						Cancel
					</button>
					<button type="submit" class="btn btn-primary">Import</button>
				</div>
                </form>
			</div>
		</div>
	</div>
	<!-- /Downlaod and Upload CSV modal -->

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8\htdocs\Booth-management\resources\views/admin/events/view.blade.php ENDPATH**/ ?>