<?php
    $currentPage = 'events';
    $count=$count;
?>
<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            <div class="col-12 mb-4">
                <div class="card card-design">
                    <div class="card-header border-bottom">
                        <div class="row py-2">
                            <div class="col-md-6 col-lg-4 mb-3 mb-md-0">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="Search by Event Name"
                                        oninput="searchEvent(this.value)" value="<?php if($search!=null): ?><?php echo e($search); ?><?php endif; ?>">
                                </div>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('event-create')): ?>
                            <div class="col-md-6 col-lg-8 text-md-end">

                                <button class="btn btn-outline-primary me-2 mb-2 mb-md-0 btn-full-sm" data-bs-toggle = "modal" data-bs-target = "#CsvModal">
                                    <i class="bx bx-export me-1"></i> Import Events
                                </button>


                                <a href="<?php echo e(route('events.create')); ?>"
                                    class="btn btn-secondary add-new btn-primary btn-full-sm mb-2 mb-md-0" type="button">
                                    <span>
                                        <i class="bx bx-plus me-0 me-sm-1"></i>
                                        <span>Add Event</span>
                                    </span>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="text-nowrap table-responsive user-table">


                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <table class="table mb-4 table-hover ">
                            <thead>
                                <tr>
                                    <th>
                                        Event Name
                                    </th>
                                    <th>
                                        Halls
                                    </th>
                                    <th>
                                        Start Date
                                    </th>
                                    <th>
                                        End Date
                                    </th>
                                    <th>
                                        Assign User
                                    </th>
                                    <th>
                                        Actions
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="eventTableData">



                            </tbody>
                        </table>
                        
                        <div class="d-flex justify-content-center" id="page-links">

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>
    <!-- / Content -->
    <script>
        // Array of predefined colors

        $(document).ready(function() {

            var data = <?php echo json_encode($events->toJson()); ?>;
            data = JSON.parse(data);
            var search="<?php echo $search; ?>";
            if(search==''){
                search=null;
            }
            console.log('new search',search);
            var htmlEvent = paginationHtml(data.links,'events',search);
            $("#page-links").html(htmlEvent);
            showEventData(data, 'eventTableData');


            $('#importButton').on('click', function() {
                $('#fileInput').click();
            });

            $('#fileInput').on('change', function() {
                if ($(this).val()) {
                    $('#csvImportForm').submit();
                }
            });


        });

        function searchEvent(value) {
            //alert(value);

            var url = "<?php echo e(route('searchEvent')); ?>";
            var method = 'POST';
            var dataType = "json";
            var parameters = {
                search: value,
            };
            requestAjax(url, method, dataType, parameters)
                .then(response => {

                    var html = paginationHtml(response.links,'events',value);
                    $("#page-links").html(html);
                    showEventData(response, 'eventTableData');
                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });


        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

<!-- Downlaod and Upload CSV modal -->
	<div class="modal csv_modal fade" id="CsvModal" tabindex="-1" aria-modal="true" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel1">Import Events</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body border-bottom border-top py-3">
					<div class="row">
						<div class="col mb-3">
							<div class = "download-sec mb-3">
								<p>
									Download the “CSV Template”, fill in the data, and then upload the file to the system.
								</p>
                                <a href="<?php echo e(route('download.sample')); ?>">
								<button class = "btn btn-primary">
									<i class='bx bxs-download me-2'></i>CSV Template
								</button>
                                </a>
							</div>
                             <form id="csvImportForm" action="<?php echo e(route('events.import')); ?>" style="display:inline"
                                    method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
							<div class="mb-3">
							  <label for="formFile" class="form-label">Upload CSV</label>
							  <input class="form-control" type="file" name="file" accept=".csv" id="formFile">
							</div>

						</div>
					</div>
				</div>
				<div class="modal-footer pt-2">
					<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
						Cancel
					</button>
					<button type="submit" class="btn btn-primary">Import</button>
				</div>

            </form>
			</div>
		</div>
	</div>
	<!-- /Downlaod and Upload CSV modal -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8\htdocs\Booth-management\resources\views/admin/events/index.blade.php ENDPATH**/ ?>