<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Booth Program</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <!-- <link rel="icon" type="image/x-icon" href="assets/images/favicon/favicon.ico" /> -->

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet" />

    <link rel="stylesheet" href="{{asset('assets/fonts/boxicons.css')}}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{asset('assets/css/core.css')}}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{asset('assets/css/theme-default.css')}}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{asset('assets/css/demo.css')}}" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="{{asset('assets/css/pages/page-auth.css')}}" />

    <!-- Custom Style Css -->
    {{-- <link rel="stylesheet" href="{{asset('assets/css/custom-style.css')}}" /> --}}
    @if($currentPage=='booth-details')
    <link rel="stylesheet" href="{{asset('assets/css/user-custom-style.css')}}" />
    @else
    <link rel="stylesheet" href="{{asset('assets/css/custom-style.css')}}" />
    @endif
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{asset('assets/libs/apex-charts/apex-charts.css')}}" />

    <!-- Select 2 Css -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- Nice Select Css -->
    <link rel="stylesheet" href="{{asset('assets/libs/nice-select/css/nice-select.css')}}">

    <!-- LightBox Gallery -->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

     <link rel="icon" href="{{ asset('assets/BLG-favicon.png') }}" type="image/x-icon">

    @yield('head')
  </head>
<body>

    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

        @include('includes.sidebar')

        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          @include('includes.nav-top')

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            @yield('content')
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    @yield('modal')
    <div class="modal fade lightbox-modal" id="lightbox-modal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-fullscreen">
            <div class="modal-content">
            <button type="button" class="btn-fullscreen-enlarge" aria-label="Enlarge fullscreen">
                <svg class="bi"><use href="#enlarge"></use></svg>
            </button>
            <button type="button" class="btn-fullscreen-exit d-none" aria-label="Exit fullscreen">
                <svg class="bi"><use href="#exit"></use></svg>
            </button>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            <div class="modal-body">
                <div class="lightbox-content">
                <!-- JS content here -->
                </div>
            </div>
            </div>
        </div>
    </div>

    <div class="bs-toast toast fade modal-submit-success" role="alert" aria-live="assertive" aria-atomic="true">
	  <div class="toast-body d-flex align-items-center gap-2">
		<i class="bx bxs-check-circle me-2" style = "font-size:30px;"></i>
		<div class="me-auto fw-medium">{{ session('success') }}</div>
	  </div>

	</div>

    <div class="bs-toast toast fade modal-submit-danger" role="alert" aria-live="assertive" aria-atomic="true">
	  <div class="toast-body d-flex align-items-center gap-2">
		<i class="bx bxs-error-circle me-2" style = "font-size:30px;"></i>
		<div class="me-auto fw-medium">@if(session()->has('failed')) {{ session('failed') }} @endif</div>
	  </div>

	</div>

    @include('includes.footer')
</body>
</html>
