</body>

<!-- Helpers -->
<script src="{{ asset('assets/js/helpers.js') }}"></script>
<!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
<!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
<script src="{{ asset('assets/js/config.js') }}"></script>

<script src="{{ asset('assets/js/libs/jquery/jquery.js') }}"></script>
<script src="{{ asset('assets/js/libs/popper/popper.js') }}"></script>
<script src="{{ asset('assets/js/bootstrap.js') }}"></script>
<script src="{{ asset('assets/js/menu.js') }}"></script>

<!-- Main JS -->
<script src="{{ asset('assets/js/main.js') }}"></script>

<!-- Vendors JS -->
<script src="{{ asset('assets/libs/apex-charts/apexcharts.js') }}"></script>

<!-- Page JS -->
<script src="{{ asset('assets/js/dashboards-analytics.js') }}"></script>

<!-- Select 2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!-- Nice Select JS -->
<script src="{{ asset('assets/libs/nice-select/js/jquery.nice-select.min.js') }}"></script>

<!-- LightBox Gallery js -->


<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
<script>
    function showData(data, target) {

        var output = '';
        var csrfToken = '{{ csrf_token() }}';
        var badgeColor = '';
        data.data.forEach(function(item) {
                var editLink = "{{ route('users.edit', ':id') }}".replace(':id', item.id);
                @auth
                var canEdit = @json(auth()->user()->can('user-edit'));
                var canDelete = @json(auth()->user()->can('user-delete'));
            @endauth
            var deleteUrl = "{{ route('users.destroy', ':id') }}".replace(':id', item.id); console.log(
            canEdit); output += '<tr>' +
            '<td>' +
            '<ul class = "nav align-items-center flex-nowrap">' +
            '<li class = "nav-item">' +
            '<div class="avatar me-3">' +
            '<span class="avatar-initial rounded-circle bg-label-';
            if (item.roles[0].name == "Admin") {


                @auth
                var userRoles = @json(auth()->user()->roles->pluck('name')->toArray());
                     canEdit = userRoles.includes('Super Admin');
                     canDelete = userRoles.includes('Super Admin'); @endauth




            output += 'primary';
            badgeColor = 'primary';
            } else if (item.roles[0].name == "Organizer") {
                output += 'info';
                badgeColor = 'info';
            } else if (item.roles[0].name == "User") {
                output += 'success';
                badgeColor = 'success';
            } else if (item.roles[0].name == "Super Admin") {

                canEdit = false;
                canDelete = false;
            }

            output += '">' +
            '<i class="bx bx-user bx-sm"></i>' +
            '</span>' +
            '</div>' +
            '</li>' +
            '<li class = "nav-item">' +
            item.name +
            '</li>' +
            '</ul>' +
            '</td>' +
            '<td>' +
            item.email +
            '</td>' +
            '<td>' +
            '<span class="badge bg-label-' + badgeColor + ' me-1">' + item.roles[0].name + '</span>' +
            '</td>' +
            '<td>' +
            '<div class="dropdown">' +
            '<button type="button" class="btn p-0 dropdown-toggle hide-arrow"' +
            'data-bs-toggle="dropdown" aria-expanded="false">' +
            '<i class="bx bx-dots-vertical-rounded"></i>' +
            '</button>' +
            '<div class="dropdown-menu" style="">' +
            '<a class="dropdown-item';
            if (!canEdit) {
                output += ' disabled';
            }
            var message = "Are you sure?";

            output += '" href="' + editLink + '"><i' +
            'class="bx bx-edit-alt me-1"></i> Edit</a>' +
            '<form onsubmit="return confirmDelete(event)" action="' + deleteUrl +
            '" method="post"><input type="hidden" name="_token" value="' + csrfToken +
            '"><input type="hidden" name="_method" value="DELETE"><button type="submit" onclick="return confirm(' +
            message + ')" class="dropdown-item ';
            if (!canDelete) {
                output += 'disabled';
            }
            output += '" ><i' +
            'class="bx bx-trash me-1"></i> Delete</button></form>' +
            '</div>' +
            '</div>' +
            '</td>' +
            '</tr>';
        });

    if (data.length == 0) {
        output = '<tr><td colspan="4" class="text-center">There is no data to show</td></tr>';
    }
    $("#" + target).html(output);
    }

    function showEventData(data, target) {
        var output = '';
        var csrfToken = '{{ csrf_token() }}';
        data.data.forEach(function(item) {
            var viewLink = "{{ route('events.show', ':id') }}".replace(':id', item.id);

            var userList = item.users.map(function(user) {
                var userInitial = user.name.charAt(0)
            .toUpperCase(); // Get the initial of the user's name
                return '<li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-xs pull-up user-avatar" title="' +
                    user.name + '">' +
                    '<span>' + userInitial + '</span>' +
                    '</li>';
            }).join('');

            output += '<tr>' +
                '<td>' +
                item.name +
                '</td>' +
                '<td>' +
                item.num_halls +
                '</td>' +
                '<td>' +
                item.start_at +
                '</td>' +
                '<td>' +
                item.end_at +
                '</td>' +
                '<td>' +
                '<ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">' +
                userList +
                '</ul>' +
                '</td>' +
                '<td>' +
                '<a href="' + viewLink + '" class="btn btn-outline-secondary">' +
                'View' +
                '</a>' +
                '</td>' +
                '</tr>';
        });

        if (data.data.length == 0) {
            output = '<tr><td colspan="6" class="text-center">There is no data to show</td></tr>';
        }
        $("#" + target).html(output);
        applyAvatarColors();
    }

    function applyAvatarColors() {
        var predefinedColors = ["#f44336", "#e91e63", "#9c27b0", "#673ab7", "#3f51b5", "#2196f3", "#03a9f4", "#00bcd4", "#009688", "#4caf50", "#8bc34a", "#cddc39", "#ffeb3b", "#ffc107", "#ff9800", "#ff5722"];
        var avatars = document.querySelectorAll('.user-avatar');
        avatars.forEach(function(avatar, index) {
            var colorIndex = index % predefinedColors.length; // Loop through colors
            var color = predefinedColors[colorIndex];
            avatar.style.backgroundColor = color;
        });
    }


    function showBoothData(data, target) {
        console.log("show booth data is",data);
        var output = '';
        var csrfToken = '{{ csrf_token() }}';
        var iconCategory = '';
        var display = '';
         @if(auth()->check())
        var canDeleteBooth = @json(auth()->user()->can('booth-delete'));
        console.log("in login",canDeleteBooth);
        @else
            var canDeleteBooth = false;
        @endif
        data.forEach(function(item) {

            var detailLink = "{{ route('booth.detail', ':id') }}".replace(':id', item.id);
            var deleteLink = "{{ route('booth.delete', ':id') }}".replace(':id', item.id);
            if (item.draft) {
                iconCategory = '';
                display = 'd-none';
            } else if (item.result == 'GOLD') {
                display = '';
                iconCategory = '{{ asset('assets/images/elements/Gold-star.svg') }}';
            } else if (item.result == 'SILVER') {
                display = '';
                iconCategory = '{{ asset('assets/images/elements/Silver-star.svg') }}';
            } else if (item.result == 'BRONZE') {
                display = '';
                iconCategory = '{{ asset('assets/images/elements/Bronze-star.svg') }}';
            } else {
                display = 'd-none';
            }
            output += '<tr>' +
                '<td>' +
                item.number +
                '</td>' +
                '<td>' +
                item.stand_type.name +
                '</td>' +
                '<td>' +
                item.size +
                '</td>' +
                '<td>' +
                item.exhibitor_name +
                '</td>' +
                '<td>' +
                '<img class="me-2 ' + display + ' " width="20" height="auto" src="' + iconCategory + '">';
            if (item.result == 'NOT' || item.draft == true) {
                output += '<span>N/A</span>';
            } else {
                output += '<span>' + item.result + '</span>';
            }
            output+='<td>';
            if(item.result!='NOT' && item.result!=null && item.draft==false){
                output+='<span class="badge bg-label-success">Submitted</span>';
            }
            else if(item.draft==true){
                output+='<span class="badge bg-label-secondary">Draft</span>';
            }
            else{
                output+='<span class="badge bg-label-warning">In Complete</span>';
            }
            output+='</td>';
            if (canDeleteBooth) {
            // Render the dropdown with detail and delete buttons
            output += '<td>' +
                '<div class="dropdown">' +
                '<button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown" aria-expanded="false">' +
                '<i class="bx bx-dots-vertical-rounded"></i>' +
                '</button>' +
                '<div class="dropdown-menu">' +
                '<a class="dropdown-item" href="' + detailLink + '">Detail</a>' +
                '<a class="dropdown-item" href="' + deleteLink + '" onclick="return confirm(\'Are you sure you want to delete this booth?\');">Delete</a>' +
                '</div>' +
                '</div>' +
                '</td>';
        } else {
            // Render the simple detail button
            output += '<td>' +
                '<a href="' + detailLink + '" class="btn btn-outline-secondary">Details</a>' +
                '</td>';
        }

        output += '</tr>';
        });

        if (data.length == 0) {
            output = '<tr><td colspan="7" class="text-center">There is no data to show</td></tr>';
        }
        $("#" + target).html(output);
    }

    function confirmDelete(event) {
        var message = "Are you sure you want to delete?";
        if (!confirm(message)) {
            event.preventDefault(); // Prevent form submission if user cancels
        }
    }

    function requestAjax(url, method, dataType = null, parameters = null) {
        var csrfToken = '{{ csrf_token() }}';
        return new Promise((resolve, reject) => { // Create a new promise
            $.ajax({
                url: url,
                method: method,
                dataType: dataType,
                data: parameters,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken); // Set the CSRF header
                },
                success: function(response) {
                    resolve(response); // Resolve the promise with the response data
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    reject(errorThrown); // Reject the promise with error information
                }
            });
        });
    }

    function paginationHtml(links, table, search = null) {

        var paginationLinks = links;
        var paginationHtml = '<nav aria-label="Page navigation">';
        paginationHtml += '<ul class="pagination">';
        var linkurl = '';
        for (var i = 0; i < paginationLinks.length; i++) {

            var link = paginationLinks[i];
            var linkurl = link.url;
            var disabled = '';
            if (link.url != null) {
                var linkurl = link.url.split("?");
                linkurl = "{{ App::make('url')->to('/') }}/" + table + "?" + linkurl[1];
            } else {
                disabled = 'disabled';
            }
            console.log("here is value", search);
            if (search != null && search != '' && search != ' ') {

                linkurl = linkurl + "&search=" + search;
            }
            console.log("links", linkurl);
            var activeClass = link.active ? 'active' : '';
            paginationHtml += '<li class="page-item ' + activeClass + '">';
            paginationHtml += '<a class="page-link ' + disabled + '" href="' + linkurl + '">' + link.label + '</a>';
            paginationHtml += '</li>';
        }

        paginationHtml += '</ul>';
        paginationHtml += '</nav>';
        return paginationHtml;
    }

    function generatePassword(length = 10) {
        const uppercaseChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        const lowercaseChars = 'abcdefghijklmnopqrstuvwxyz';
        const numberChars = '0123456789';
        const specialChars = '!@#$%^&*()-_+=<>?';

        const allChars = uppercaseChars + lowercaseChars + numberChars + specialChars;

        let password = '';
        let hasUppercase = false;
        let hasLowercase = false;
        let hasNumber = false;
        let hasSpecialChar = false;

        // Ensure at least one character from each character set
        password += uppercaseChars[Math.floor(Math.random() * uppercaseChars.length)];
        password += lowercaseChars[Math.floor(Math.random() * lowercaseChars.length)];
        password += numberChars[Math.floor(Math.random() * numberChars.length)];
        password += specialChars[Math.floor(Math.random() * specialChars.length)];

        for (let i = 0; i < length - 4; i++) {
            password += allChars[Math.floor(Math.random() * allChars.length)];
        }

        // Shuffle the characters
        password = password.split('').sort(() => Math.random() - 0.5).join('');

        return password;
    }

    function loadToast(){

        var $modal = $('.modal-submit-success');

		// Add the animation class to show the modal
		$modal.addClass('animate__animated animate__slideInRight');

		// Show the modal
		$modal.addClass('show');

		// Hide the modal after 5 seconds
		setTimeout(function() {
			// Reverse the animation class and hide the modal
			$modal.removeClass('animate__slideInRight').addClass('animate__slideOutRight');

			// Remove the 'show' class after the animation completes
			setTimeout(function() {
				$modal.removeClass('show animate__slideOutRight');
			}, 1000); // Assuming slideOutRight animation duration is 1 second (1000 milliseconds)
		}, 3000); // 5000 milliseconds = 2 seconds
    }

    function loadErrorToast(){
         var $modal = $('.modal-submit-danger');
        console.log($modal);
		// Add the animation class to show the modal
		$modal.addClass('animate__animated animate__slideInRight');

		// Show the modal
		$modal.addClass('show');

		// Hide the modal after 5 seconds
		setTimeout(function() {
			// Reverse the animation class and hide the modal
			$modal.removeClass('animate__slideInRight').addClass('animate__slideOutRight');

			// Remove the 'show' class after the animation completes
			setTimeout(function() {
				$modal.removeClass('show animate__slideOutRight');
			}, 1000); // Assuming slideOutRight animation duration is 1 second (1000 milliseconds)
		}, 3000); // 5000 milliseconds = 2 seconds

    }



    $(document).ready(function() {
        @if(session()->has('error') || session()->has('failed'))
        loadErrorToast();
        @endif
        @if(session()->has('success'))
        loadToast();
        @endif
        $('.multiselect-events').select2();
    });

    $(document).ready(function() {
        $('.user-assign').select2();
    });

    $(document).ready(function() {
        $('.usertype-select').niceSelect();
    });
</script>
