@extends('layouts.app')
@php
    $currentPage = 'admin-dashboard';
@endphp
@section('content')
    {{-- <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            <!-- Order Statistics -->
            <div class="col-md-6 col-lg-8 mb-2">
                <div class="card h-100 total-events-card dashboard-card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <ul class="p-0 m-0">
                                    <li class="d-flex mb-4 pb-1 align-items-center">
                                        <div class="avatar flex-shrink-0 me-3">
                                            <span class="avatar-initial rounded bg-transparent">
                                                <i class='bx bxs-store text-primary'></i>
                                            </span>
                                        </div>
                                        <div
                                            class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2 info-col">
                                            <div class="me-2">
                                                <h5 class="mb-0">Total Events</h5>
                                                <small class="text-muted">Cumulative Events in the System</small>
                                            </div>
                                            <div class="user-progress">
                                                <small class="fw-medium">400</small>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="d-flex mb-4 pb-1 align-items-center">
                                        <div class="avatar flex-shrink-0 me-3">
                                            <span class="avatar-initial rounded bg-transparent">
                                                <i class='bx bxs-check-circle text-success'></i>
                                            </span>
                                        </div>
                                        <div
                                            class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2 info-col">
                                            <div class="me-2">
                                                <h5 class="mb-0">Completed Events</h5>
                                                <small class="text-muted">Events with completed Booth Report</small>
                                            </div>
                                            <div class="user-progress">
                                                <small class="fw-medium">150</small>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="d-flex mb-4 pb-1 align-items-center">
                                        <div class="avatar flex-shrink-0 me-3">
                                            <span class="avatar-initial rounded bg-transparent"><i
                                                    class='bx bxs-pie-chart-alt text-info'></i></span>
                                        </div>
                                        <div
                                            class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2 info-col">
                                            <div class="me-2">
                                                <h5 class="mb-0">In-progress Events</h5>
                                                <small class="text-muted">Events with incomplete Booth Report</small>
                                            </div>
                                            <div class="user-progress">
                                                <small class="fw-medium">250</small>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4 mb-2">
                <div class="card h-100">
                    <div class="card-body">
                        <div id="orderStatisticsChart" class = "totalEventChart" style = "margin:auto;"></div>
                    </div>
                </div>
            </div>
            <!--/ Order Statistics -->

            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-title d-flex align-items-start justify-content-between mb-0">
                                        <div class="avatar flex-shrink-0">
                                            <img src="assets/images/icons/unicons/Booth-icon.svg" alt="Credit Card"
                                                class="rounded" />
                                        </div>
                                    </div>
                                    <div class="card-result">
                                        <span>Total Stands</span>
                                        <h3 class="card-title text-nowrap mb-1">200</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-title d-flex align-items-start justify-content-between mb-0">
                                        <div class="avatar flex-shrink-0">
                                            <img src="assets/images/elements/Gold-star.svg" alt="Gold star"
                                                class="rounded" />
                                        </div>
                                    </div>
                                    <div class="card-result">
                                        <span>Gold Booth</span>
                                        <h3 class="card-title text-nowrap mb-1">30</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-title d-flex align-items-start justify-content-between mb-0">
                                        <div class="avatar flex-shrink-0">
                                            <img src="assets/images/elements/Silver-star.svg" alt="Silver Star"
                                                class="rounded" />
                                        </div>
                                    </div>
                                    <div class="card-result">
                                        <span>Silver Booth</span>
                                        <h3 class="card-title text-nowrap mb-1">80</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-title d-flex align-items-start justify-content-between mb-0">
                                        <div class="avatar flex-shrink-0">
                                            <img src="assets/images/elements/Bronze-star.svg" alt="Bronze Star"
                                                class="rounded" />
                                        </div>
                                    </div>
                                    <div class="card-result">
                                        <span>Bronze Booth</span>
                                        <h3 class="card-title text-nowrap mb-1">50</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 mb-4 d-none">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Filter</h5>
                        <div class="d-flex justify-content-between align-items-center row py-3 gap-3 gap-md-0">
                            <div class="col-md-4 product_status"><select id="ProductStatus"
                                    class="form-select text-capitalize">
                                    <option value="">Status</option>
                                    <option value="Scheduled">Scheduled</option>
                                    <option value="Publish">Publish</option>
                                    <option value="Inactive">Inactive</option>
                                </select></div>
                            <div class="col-md-4 product_category"><select id="ProductCategory"
                                    class="form-select text-capitalize">
                                    <option value="">Category</option>
                                    <option value="Household">Household</option>
                                    <option value="Office">Office</option>
                                    <option value="Electronics">Electronics</option>
                                    <option value="Shoes">Shoes</option>
                                    <option value="Accessories">Accessories</option>
                                    <option value="Game">Game</option>
                                </select></div>
                            <div class="col-md-4 product_stock"><select id="ProductStock"
                                    class="form-select text-capitalize">
                                    <option value=""> Stock </option>
                                    <option value="Out_of_Stock">Out of Stock</option>
                                    <option value="In_Stock">In Stock</option>
                                </select></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div> --}}
    <!-- / Content -->


    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="row dashboard-nav">
            <div class="col-12">
                <ul class="nav nav-fill nav-tabs border-bottom-0">
                    <li class="nav-item active" data-bs-toggle="tab" data-bs-target="#overll-dashboard">
                        <span class="button-radio">
                            <div class="br-inner"></div>
                        </span>
                        Overall Dashboard
                    </li>
                    <li class="nav-item" data-bs-toggle="tab" data-bs-target="#events-dashboard">
                        <span class="button-radio">
                            <div class="br-inner"></div>
                        </span>
                        Events Dashboard
                    </li>
                </ul>
            </div>
        </div>

        <div class="tab-content p-0">

            <div class="tab-pane fade show active" id="overll-dashboard">
                <div class="dashboard-body">

                    <div class="row">
                        <div class="col-12">
                            <div class="dashboard-heading">
                                Overall Information
                            </div>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-xl-8 mb-3 mb-xl-0">

                            <div class="row mb-1">

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2">
                                    <div class="card event-card total-event">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Total Event </span>
                                                    <h3 class="card-title text-nowrap mb-1">{{ $countEvents }}</h3>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2">
                                    <div class="card event-card complete-event">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Completed Events</span>
                                                    <h3 class="card-title text-nowrap mb-1">{{ $countCompleted }}</h3>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2">
                                    <div class="card event-card inprogress-event">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>In-progress Events</span>
                                                    <h3 class="card-title text-nowrap mb-1">{{ $countProgress }}</h3>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row mt-2">

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2 mb-xl-0">
                                    <div class="card event-card c-card gold" >
                                        <div class="card-header position-relative">
                                            Gold Stands
                                            <div class="cb-icon">
                                                <img src="assets/images/elements/Gold-star.svg" alt="Gold star"
                                                    class="rounded">
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            {{ $countGold }}
                                        </div>
                                        <div class="card-footer text-center">
                                            Total Area: <span>{{ $sizeGold }}</span> m<sup>2</sup>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2 mb-xl-0">
                                    <div class="card event-card c-card silver">
                                        <div class="card-header position-relative">
                                            Silver Stands
                                            <div class="cb-icon">
                                                <img src="assets/images/elements/Silver-star.svg" alt="Silver Star"
                                                    class="rounded">
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            {{ $countSilver }}
                                        </div>
                                        <div class="card-footer text-center">
                                            Total Area: <span>{{ $sizeSilver }}</span> m<sup>2</sup>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2 mb-xl-0">
                                    <div class="card event-card c-card bronze">
                                        <div class="card-header position-relative">
                                            Bronze Stands
                                            <div class="cb-icon">
                                                <img src="assets/images/elements/Bronze-star.svg" alt="Bronze Star"
                                                    class="rounded">
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            {{ $countBronze }}
                                        </div>
                                        <div class="card-footer text-center">
                                            Total Area: <span>{{ $sizeBronze }}</span> m<sup>2</sup>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-xl-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <div id="orderStatisticsChart" class="totalEventChart" style="margin:auto;"></div>
                                    <div class="p-title">
                                        <ul class="nav">
                                            <li class="nav-item">
                                                <div class="d-flex align-items-center">
                                                    <div class="color-box completed"></div>
                                                    <span>Completed</span>
                                                </div>
                                            </li>
                                            <li class="nav-item">
                                                <div class="d-flex align-items-center">
                                                    <div class="color-box inprogress"></div>
                                                    <span>In-progress</span>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="events-dashboard">
                <div class="dashboard-body">

                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="dashboard-heading">
                                <div class="event-name" id="eventName">

                                </div>
                                <div class="organizer-name" id="">
                                    Organizer: <span id="organizerName"></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">

                            <div class="form-group filterEvent-select">
                                <label for="filter-event">Filter Event</label>
                                <select class="form-select filter-events" id="filter_events" >
                                    <option selected="" disabled>Event Name</option>
                                    @foreach($eventsDropdown as $eventDropdown)
                                        <option value="{{ $eventDropdown->id }}">{{ $eventDropdown->name }}</option>
                                    @endforeach

                                </select>
                            </div>

                        </div>
                    </div>

                    <div class="row mt-3">

                        <div class="col-xl-8 mb-3 mb-xl-0">

                            <div class="row mb-1">

                                <div class="col-lg-7 col-xl-12 col-xxl-8 mb-2">
                                    <div class="card event-card total-event ed-card  h-100">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-around">
                                                <div class="card-result">
                                                    <span>Total Stands</span>
                                                    <h3 class="card-title text-nowrap mb-1" id="totalStands">
                                                        0
                                                    </h3>
                                                </div>
                                                <div class="card-result">
                                                    <span>Completed</span>
                                                    <h3 class="card-title text-nowrap mb-1" id="completedStands">
                                                        0
                                                    </h3>
                                                </div>
                                                <div class="card-result">
                                                    <span>Pending</span>
                                                    <h3 class="card-title text-nowrap mb-1" id="pendingStands">
                                                       0
                                                    </h3>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-5 col-xl-12 col-xxl-4 mb-2">
                                    <div class="card event-card complete-event">
                                        <div class="card-body">
                                            <div
                                                class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                <div class="card-result">
                                                    <span>Total Stands Area</span>
                                                    <h3 class="card-title text-nowrap mb-1" id="totalStandsArea">
                                                        0 m<sup>2</sup>
                                                    </h3>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row mt-2">

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2 mb-xl-0">
                                    <div class="card event-card c-card gold">
                                        <div class="card-header position-relative">
                                            Gold Stands
                                            <div class="cb-icon">
                                                <img src="assets/images/elements/Gold-star.svg" alt="Gold star"
                                                    class="rounded">
                                            </div>
                                        </div>
                                        <div class="card-body" id="goldStands">
                                            0
                                        </div>
                                        <div class="card-footer text-center" id="goldSize">
                                            Total Area: <span></span> m<sup>2</sup>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2 mb-xl-0">
                                    <div class="card event-card c-card silver">
                                        <div class="card-header position-relative">
                                            Silver Stands
                                            <div class="cb-icon">
                                                <img src="assets/images/elements/Silver-star.svg" alt="Silver Star"
                                                    class="rounded">
                                            </div>
                                        </div>
                                        <div class="card-body" id="silverStands">
                                            0
                                        </div>
                                        <div class="card-footer text-center" id="silverSize">
                                            Total Area: <span></span> m<sup>2</sup>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-lg-4 col-xl-4 mb-2 mb-xl-0">
                                    <div class="card event-card c-card bronze">
                                        <div class="card-header position-relative">
                                            Bronze Stands
                                            <div class="cb-icon">
                                                <img src="assets/images/elements/Bronze-star.svg" alt="Bronze Star"
                                                    class="rounded">
                                            </div>
                                        </div>
                                        <div class="card-body" id="bronzeStands">
                                            0
                                        </div>
                                        <div class="card-footer text-center" id="bronzeSize">
                                            Total Area: <span></span> m<sup>2</sup>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-xl-4">
                            <div class="card graph-card h-100">
                                <div class="card-body">
                                    <div class="graph-body">
                                        <div class="graph-inner">
                                            <div class="graph-progress bronze position-relative" id="bronzeData" data-value="0">
                                                <div class="graph-progress-inner"></div>
                                                <div class="progress-title">
                                                    Bronze
                                                </div>
                                                <div class="value">0%</div>
                                            </div>
                                            <div class="graph-progress silver position-relative" id="silverData" data-value="0">
                                                <div class="graph-progress-inner"></div>
                                                <div class="progress-title">
                                                    Silver
                                                </div>
                                                <div class="value">0%</div>
                                            </div>
                                            <div class="graph-progress gold position-relative" id="GoldData" data-value="0">
                                                <div class="graph-progress-inner"></div>
                                                <div class="progress-title">
                                                    Gold
                                                </div>
                                                <div class="value">0%</div>
                                            </div>
                                        </div>
                                        <div class="graph-value">
                                            <ul class="nav">
                                                <li class="nav-item">0</li>
                                                <li class="nav-item">20</li>
                                                <li class="nav-item">40</li>
                                                <li class="nav-item">60</li>
                                                <li class="nav-item">80</li>
                                                <li class="nav-item">100</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>
    @if(Auth::user()->getRoleNames()->first()!='Admin' && Auth::user()->getRoleNames()->first()!='Super Admin')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            <div class="col-12 mb-4">
                <div class="card card-design">
                    <div class="card-header border-bottom">
                        <div class="row py-2">
                            <div class="col-md-6 col-lg-4 mb-3 mb-md-0">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="Search by Event Name"
                                        oninput="searchEvent(this.value)" value="@if($search!=null){{ $search }}@endif">
                                </div>
                            </div>
                            @can('event-create')
                            <div class="col-md-6 col-lg-8 text-md-end">
                                <form id="csvImportForm" action="{{ route('events.import') }}" style="display:inline"
                                    method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input type="file" name="file" id="fileInput" style="display: none;" required>
                                    <button type="button" class="btn btn-outline-primary me-2 mb-2 mb-md-0 btn-full-sm"
                                        id="importButton">
                                        <i class="bx bx-export me-1"></i> Import CSV
                                    </button>
                                </form>

                                <a href="{{ route('events.create') }}"
                                    class="btn btn-secondary add-new btn-primary btn-full-sm mb-2 mb-md-0" type="button">
                                    <span>
                                        <i class="bx bx-plus me-0 me-sm-1"></i>
                                        <span>Add Event</span>
                                    </span>
                                </a>

                            </div>
                            @endcan
                        </div>
                    </div>
                    <div class="text-nowrap table-responsive user-table">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <table class="table mb-4 table-hover ">
                            <thead>
                                <tr>
                                    <th>
                                        Event Name
                                    </th>
                                    <th>
                                        Halls
                                    </th>
                                    <th>
                                        Start Date
                                    </th>
                                    <th>
                                        End Date
                                    </th>
                                    <th>
                                        Assign User
                                    </th>
                                    <th>
                                        Actions
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="eventTableData">

                                <tr><td colspan="6" class="text-center">There is no data to show</td></tr>

                            </tbody>
                        </table>

                        <div class="d-flex justify-content-center" id="page-links">

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
    @endif


    <div class="content-backdrop fade"></div>
    <script>
        // Order Statistics Chart
        // --------------------------------------------------------------------
        $(document).ready(function(){
            console.log("new count is:",{{ $events->count() }});

            $('#filter_events').select2();
            var totalEvents="{{ $events->count() }}";
            if(totalEvents!=0){
                var data = {!! json_encode($events->toJson()) !!};
                console.log("logs:",data);
                data = JSON.parse(data);
                console.log(data);
                var search="{!! $search !!}";
                if(search==''){
                    search=null;
                }
                console.log('new search',search);

                var htmlEvent = paginationHtml(data.links,'home',search);
                $("#page-links").html(htmlEvent);
                showEventData(data, 'eventTableData');
            }



            $('#importButton').on('click', function() {
                $('#fileInput').click();
            });

            $('#fileInput').on('change', function() {
                if ($(this).val()) {
                    $('#csvImportForm').submit();
                }
            });



            let cardColor, headingColor, axisColor, shadeColor, borderColor;

            cardColor = config.colors.cardColor;
            headingColor = config.colors.headingColor;
            axisColor = config.colors.axisColor;
            borderColor = config.colors.borderColor;
            const chartOrderStatistics = document.querySelector('#orderStatisticsChart'),
            orderChartConfig = {
            chart: {
                height: 260,
                width: 240,
                type: 'donut'
            },
            labels: ['Completed', 'Inprogress'],
            series: [{{ $countCompletedPercentage }}, {{ $countProgressPercentage }}],
            colors: [config.colors.completed,config.colors.inprogress],
            stroke: {
                width: 5,
                colors: [cardColor]
            },
            dataLabels: {
                enabled: false,
                formatter: function (val, opt) {
                return parseInt(val) ;
                }
            },
            legend: {
                show: false
            },
            grid: {
                padding: {
                top: 0,
                bottom: 0,
                right: 15
                }
            },
            states: {
                hover: {
                filter: { type: 'none' }
                },
                active: {
                filter: { type: 'none' }
                }
            },
            plotOptions: {
                pie: {
                donut: {
                    size: '65%',
                    labels: {
                    show: true,
                    value: {
                        fontSize: '1.5rem',
                        fontFamily: 'Public Sans',
                        color: headingColor,
                        offsetY: -15,
                        formatter: function (val) {
                        return parseInt(val) + '%';
                        }
                    },
                    name: {
                        offsetY: 20,
                        fontFamily: 'Public Sans'
                    },
                    total: {
                        show: true,
                        fontSize: '0.7125rem',
                        color: axisColor,
                        label: 'Total Event',
                        formatter: function (w) {
                        return '{{ $countEvents }}';
                        }
                    }
                    }
                }
                }
            }
            };
        if (typeof chartOrderStatistics !== undefined && chartOrderStatistics !== null) {
            const statisticsChart = new ApexCharts(chartOrderStatistics, orderChartConfig);
            statisticsChart.render();
        }

        var event_id=$("#filter_events").val();
            console.log("blabla","bla");
        console.log("event_id is",event_id);

        $("#filter_events").change(function(){
            event_id=$(this).val();
            loadEventStats(event_id);
        });

            function loadEventStats(event_id){
            var url="{{ route('event.stats') }}";
            var method='post';
            var dataType=null;
            var parameters = {
                event_id: event_id
            };

            requestAjax(url, method, dataType, parameters)
                .then(response => {
                    console.log("load events stats",response);
                    console.log("GOLD",response.goldBoothsCount);
                    var goldPercent=(response.total_booths!=0)?(response.goldBoothsCount/response.total_booths)*100:0;
                    goldPercent=parseInt(goldPercent);
                    var bronzePercent=(response.total_booths!=0)?(response.bronzeBoothsCount/response.total_booths)*100:0;
                    bronzePercent=parseInt(bronzePercent);

                    var silverPercent=(response.total_booths!=0)?(response.silverBoothsCount/response.total_booths)*100:0;
                    silverPercent=parseInt(silverPercent);

                    $("#totalStands").html(response.total_booths);
                    $("#completedStands").html(response.completed);
                    $("#pendingStands").html(response.pending);
                    $("#totalStandsArea").html(response.total_size+' m<sup>2</sup>');
                    $("#goldStands").html(response.goldBoothsCount);
                    $("#goldSize span").html(response.goldBoothsSize);
                    $("#silverSize span").html(response.silverBoothsSize);
                    $("#bronzeSize span").html(response.bronzeBoothsSize);
                    console.log(goldPercent);
                    $('#GoldData').attr('data-value', goldPercent);
                    $('#silverData').attr('data-value', silverPercent);
                    $('#bronzeData').attr('data-value', bronzePercent);


                    // Update the percentage text

                    $("#silverStands").html(response.silverBoothsCount);



                    // Update the percentage text
                    $('#silverData .value').text(response.silverBoothsCount + '%');

                    $("#bronzeStands").html(response.bronzeBoothsCount);



                    // Update the percentage text
                    $('#bronzeData .value').text(response.bronzeBoothsCount + '%');
                    console.log("organizers name",response.event.organizers);
                    let organizers = response.event.organizers;

                    // Extract the names of the organizers
                    let organizerNames = organizers.map(organizer => organizer.name);

                    // Join the names into a comma-separated string
                    let organizerNamesString = organizerNames.join(', ');

                    // Append the string to the HTML element with id 'organizerName'
                    $("#organizerName").html(organizerNamesString);
                    //$("#organizerName").html(response.event.users);
                    $("#eventName").html(response.event.name);
                    loadBars();


                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });
            }
            });
            function searchEvent(value) {
            //alert(value);

            var url = "{{ route('searchEvent') }}";
            var method = 'POST';
            var dataType = "json";
            var parameters = {
                search: value,
            };
            requestAjax(url, method, dataType, parameters)
                .then(response => {

                    var html = paginationHtml(response.links,'events',value);
                    $("#page-links").html(html);
                    showEventData(response, 'eventTableData');
                })
                .catch(error => {
                    console.error(error); // Handle errors (e.g., display error messages)
                });


        }
        function loadBars(){
            var progressBars = document.querySelectorAll('.graph-progress');

            progressBars.forEach(function(bar) {
                var progress = bar.querySelector('.graph-progress-inner');
                var value = bar.dataset.value;
                var valueDisplay = bar.querySelector('.value');

                progress.style.width = '0%'; // Set initial width to 0%
                valueDisplay.textContent = value + '%';
                console.log("valueDisplay",value);
            });


                $('#events-dashboard .graph-progress-inner').css('width', '0%'); // Reset width to 0% when tab is activated

                setTimeout(function() {
                    $('#events-dashboard .graph-progress').each(function() {
                        var $progressBar = $(this);
                        var value = parseInt($progressBar.attr('data-value'));
                        console.log(value);
                        var $progress = $progressBar.find('.graph-progress-inner');

                        if (!isNaN(value)) {
                            $progress.animate({ width: value + '%' }, 300);
                            $progressBar.find('.value').text(value + '%');
                        }
                    });
                }, 500); // Delay animation by 1 second

        }
        document.addEventListener("DOMContentLoaded", function() {
            loadBars();

        });

    </script>
@endsection
