@extends('layouts.auth')
@php
    $pageName = 'reset';
@endphp
@section('content')
    <!-- Logo -->
    <div class="app-brand justify-content-center">
        <a href="index.php" class="app-brand-link gap-2">
            <span class="app-brand-logo demo">
                <img src="{{ asset('assets/images/logos/BLG-Logo-light.png') }}" alt="BLG-logo">
            </span>
        </a>
    </div>
    <!-- /Logo -->
    <h4 class="mb-2">{{ __('Reset Password') }}</h4>
    {{-- <p class="mb-4">Enter your email and we'll send you instructions to reset your password</p> --}}
    @if (session('status'))
        <div class="alert alert-success" role="alert">
            {{-- {{ session('status') }} --}}
            <p>Please Check your email for password reset link.</p>
        </div>
    @else
        <form id="formAuthentication" class="mb-3" method="POST" action="{{ route('password.update') }}">
        @csrf

        <input type="hidden" name="token" value="{{ $token }}">
        <div class="mb-3">
            <label for="email" class="form-label">{{ __('Email Address') }}</label>
            <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email"
                placeholder="Enter your email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus
                autofocus />
            @error('email')
                <div class="form-error" role="alert">
                    {{ $message }}
                </div>
            @enderror
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">{{ __('Password') }}</label>
            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror"
                name="password" required autocomplete="new-password">
            @error('password')
                <div class="form-error" role="alert">
                    {{ $message }}
                </div>
            @enderror
            <div id="passwordError" class="form-error mt-1">
            @error('password')
                {{ $message }}
            @enderror
        </div>
        </div>


        <div class="mb-3">
            <label for="password_confirmation" class="form-label">{{ __('Confirm Password') }}</label>
            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required
                autocomplete="new-password">
            @error('password_confirmation')
                <div class="form-error" role="alert">
                    {{ $message }}
                </div>
            @enderror
        </div>


        <button class="btn btn-primary d-grid w-100" type="submit">
            {{ __('Reset Password') }}
        </button>
    </form>
    @endif

    <div class="text-center">
        <a href="{{ route('login') }}" class="d-flex align-items-center justify-content-center">
            <i class="bx bx-chevron-left scaleX-n1-rtl bx-sm"></i>
            Back to login
        </a>
    </div>


 <script>
    $(document).ready(function(){
        $.validator.addMethod("passwordPattern", function(value, element) {
                    return this.optional(element) ||
                        /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]).{8,}$/.test(
                            value);
                },
                "Your password must contain at least one uppercase letter, one lowercase letter, one number, and one special character."
            );


            $('#formAuthentication').validate({
                ignore: [],
                rules: {
                    password: {
                        required: true,
                        minlength: 8,
                        passwordPattern: true
                    },

                    email: {
                        required: true,
                        email: true
                    },

                },
                messages: {
                    password: {
                        required: "Please enter a password",
                        minlength: "Your password must be at least 8 characters long",
                        passwordPattern: "Your password must contain at least one uppercase letter, one lowercase letter, one number, and one special character."
                    },


                    email: {
                        required: "Please enter your email address",
                        email: "Please enter a valid email address"
                    },

                },
                errorPlacement: function(error, element) {
                    var errorElementId = element.attr('id') +
                        'Error'; // Get the ID of the corresponding error message div
                    $('#' + errorElementId).text(error
                        .text()
                    ); // Insert the error message text into the corresponding error message div
                },
                highlight: function(element, errorClass, validClass) {
                    var value = $(element).val();
                    var hasUpperCase = /[A-Z]/.test(value);
                    var hasLowerCase = /[a-z]/.test(value);
                    var hasNumber = /\d/.test(value);
                    var hasSpecialChar = /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(value);
                    var passwordLength = value.length;

                    // Check if the element being validated is the password field
                    if (element.id === 'password') {
                        if (hasUpperCase) {
                            $('.password-instruction b:contains("uppercase")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("uppercase")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasLowerCase) {
                            $('.password-instruction b:contains("lowercase")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("lowercase")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasNumber) {
                            $('.password-instruction b:contains("number")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("number")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasSpecialChar) {
                            $('.password-instruction b:contains("special character")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("special character")').addClass(
                                'invalid').removeClass('valid');
                        }

                        if (passwordLength >= 8) {
                            $('.password-instruction').find('b:contains("8")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction').find('b:contains("8")').addClass('invalid')
                                .removeClass('valid');
                        }
                    }
                },
                unhighlight: function(element, errorClass, validClass) {
                    var errorElementId = $(element).attr('id') + 'Error';
                    $('#' + errorElementId).empty();
                },
                submitHandler: function(form) {
                    form.submit(); // Submit the form if all validation passes
                }
            });
    });


</script>
@endsection
