@extends('layouts.auth')
@php
    $pageName = 'email';
@endphp
@section('content')
<div class="app-brand justify-content-center">
        <a href="{{ route('home') }}" class="app-brand-link gap-2">
            <span class="app-brand-logo demo">
                <img src="{{ asset('assets/images/logos/BLG-Logo-light.png') }}" alt="BLG-logo">
            </span>
        </a>
    </div>
    <p class = "text-center">Forgot Password?</p>
        @if(!session('status'))
                    <p class="fp-pra">Enter your email and we'll send you instructions to reset your password</p>
                    @endif
    @if (session('status'))
        <div class="alert alert-success" role="alert">
            {{-- {{ session('status') }} --}}
            Please Check your email for password reset link.
        </div>
    @else
    <form id="formAuthentication" class="mb-3" action="{{ route('password.email') }}" method="post">
        @csrf
        <div class="form-group">
            <label for="email" class="form-label">Email</label>
            <input type="text" class="form-control @error('email') is-invalid @enderror" id="email" name="email"
                placeholder="Enter your email" value="{{ old('email') }}" required autocomplete="email" autofocus
                autofocus />
            @error('email')
                <div class="form-error" role="alert">
                    {{ $message }}
                </div>
            @enderror
        </div>
        <div class="form-group">
        <button class="btn btn-primary d-grid w-100" type="submit">Send Reset Link</button>
        </div>
    </form>
    @endif
    <div class="form-group text-center mt-3">
        <a href="{{ route('login') }}" class="d-flex align-items-center justify-content-center">
            <i class="bx bx-chevron-left scaleX-n1-rtl bx-sm"></i>
            Back to login
        </a>
    </div>
@endsection
