@extends('layouts.app')
@php
    $currentPage = 'permissions';
@endphp
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">


            <form action="{{ route('roles.store') }}" method="post">
                                @csrf
            <div class="col-12 mb-2">
                <div class="card">
                    <div class="mt-2 mx-2">
                        <div class="row py-2">
                            <div class="col-sm-7 col-md-6 col-lg-4 mb-3 mb-md-0">

                            </div>

                            <div class="col-sm-5 col-md-6 col-lg-8 text-md-end">
                                <button type="submit"
                                    class="btn btn-secondary add-new btn-primary btn-full-sm full-width-sm" type="button">
                                    <span>
                                        <i class="bx bx-plus me-0 me-sm-1"></i>
                                        <span>Update Permissions</span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="text-nowrap table-responsive user-table">
                        @if(session()->has('success'))
                            <div class="alert alert-success">
                                {{ session()->get('success') }}
                            </div>
                        @elseif(session()->has('failed'))
                            <div class="alert alert-danger">{{ session('failed') }}</div>
                        @endif
                        <table class="table mb-4 table-hover">
                            <thead>
                                <tr>
                                    <th>
                                        Permissions
                                    </th>
                                    @foreach($roles as $role)
                                    <th>
                                        {{ $role->name }}
                                    </th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="userTableData">
                                @foreach($permissions as $permission)
                                    <tr>
                                        <th>{{ $permission->name }}</th>

                                        @foreach($roles as $role)
                                            <td>
                                                <input type="checkbox" class="" @if($role->hasPermissionTo($permission->name)){{ "checked" }} @endif name="{{ $role->id }}[]" value="{{ $permission->name }}">
                                            </td>
                                        @endforeach
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </form>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>
    <!-- / Content -->


@endsection
