@extends('layouts.app')
@php
    $currentPage = 'events';
@endphp
@section('content')
@php
    use Carbon\Carbon;

@endphp
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            <!-- Booths Statistics -->
            <div class="col-md-12 mb-2">
                <div class="card h-100 total-events-card">
                <div class="card-body">

                    <div class="card-header d-flex align-items-center justify-content-between px-0 pt-0">
                        <div class="card-title mb-0 d-flex justify-content-between w-100 align-items-center">
                            <div class="title-info">
                                <h1 class="m-0 me-2">{{ $event->name }}</h1>
                            </div>
                            <div class = "edit-side">
                                <div class="edit-btn">
                                    <a href="{{ route('events.edit',$event->id) }}" class="btn btn-icon btn-outline-secondary">
                                        <span class="tf-icons bx bx-edit"></span>
                                    </a>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="row align-item-center justify-content-between">
                        <div class="col">
                            <div class = "mt-2">{{ Carbon::parse($event->start_at)->format('d-M-Y') }} To {{ Carbon::parse($event->end_at)->format('d-M-Y') }}</div>
                        </div>
                        <div class="col">
                            <ul class="p-0 m-0">
                                <li class="d-flex justify-content-end pb-1">
                                    <div class="me-1">
                                        Assigned To: {{ $event->user->name }}
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>

                </div>
                </div>
            </div>

            <div class="col-12">
                <div class="row">
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card h-100">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                        <span class = "mb-2">Total number of Booths</span>
                                        <h3 class="card-title text-nowrap mb-1">{{ $total_booths }}</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card h-100">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                        <span class = "mb-2">Net m<sup>2</sup> of all Booths</span>
                                        <h3 class="card-title text-nowrap mb-1">{{ $total_size }}</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card h-100">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                        <span class = "mb-2">Booths that are disposable</span>
                                        <h3 class="card-title text-nowrap mb-1">1276</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-xl-3 mb-2">
                        <div class="card event-card h-100">
                            <div class="card-body">
                                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                    <div class="card-result d-flex w-100 flex-wrap justify-content-between flex-column">
                                        <span class = "mb-2">m<sup>2</sup> of Booths that are disposable</span>
                                        <h3 class="card-title text-nowrap mb-1">14610.5</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--/ Booths Statistics -->

            <div class="col-md-12 mb-2 d-none">
                <div class="nav-align-top mb-4 d-flex align-items-start flex-row">
                    <ul class="nav nav-pills mb-3 booth-tab flex-column me-4" role="tablist">
                        <li class="nav-item">
                            <button
                            type="button"
                            class="nav-link active"
                            role="tab"
                            data-bs-toggle="tab"
                            data-bs-target="#navs-pills-top-home"
                            aria-controls="navs-pills-top-home"
                            aria-selected="true">
                                Hall 1
                        </button>
                        </li>
                        <li class="nav-item">
                            <button
                            type="button"
                            class="nav-link"
                            role="tab"
                            data-bs-toggle="tab"
                            data-bs-target="#navs-pills-top-profile"
                            aria-controls="navs-pills-top-profile"
                            aria-selected="false">
                                Hall 2
                            </button>
                        </li>
                        <li class="nav-item">
                            <button
                            type="button"
                            class="nav-link"
                            role="tab"
                            data-bs-toggle="tab"
                            data-bs-target="#navs-pills-top-messages"
                            aria-controls="navs-pills-top-messages"
                            aria-selected="false">
                                Hall 3
                            </button>
                        </li>
                    </ul>
                    <div class="tab-content w-100">
                        <div class="tab-pane fade show active" id="navs-pills-top-home" role="tabpanel">
                            <div class="b-table-header pb-3 border-bottom">
                                <div class="row pb-2 booth-title justify-content-between">
                                    <div class="col-6 col-md-8">
                                        <div class = "hall-name d-flex align-items-center">
                                            <h4 class = "mb-0">Hall 1</h4>
                                            <button class="btn btn-icon p-0 border-0 background-transparent ms-2"
                                            data-bs-toggle = "modal" data-bs-target = "#editHallModal">
                                                <span class="tf-icons bx bx-edit"></span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class = "col-6 col-md-4 text-end">
                                        <h4 class = "mb-0">Total Booths: {{ $total_booths }}</h4>
                                    </div>
                                </div>
                                <div class="row py-3 align-items-center">
                                    <div class="col-md-6 col-lg-4 mb-3 mb-lg-0">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="search">
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-8 text-md-end">
                                        <button class="btn btn-outline-primary me-2">
                                            <i class="bx bx-export me-1"></i> Import Booths
                                        </button>
                                        <a href = "add-event.php" class="btn btn-secondary add-new btn-primary" type="button">
                                            <span>
                                                <i class="bx bx-plus me-0 me-sm-1"></i>
                                                <span class="d-none d-sm-inline-block">Add Booth</span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="text-nowrap table-responsive user-table booth-table">
                                <table class="table mb-4 table-hover ">
                                    <thead>
                                        <tr>
                                            <th>
                                                Booth Numbernnnn
                                            </th>
                                            <th>
                                                Booth Size m<sup>2</sup>
                                            </th>
                                            <th>
                                                Exhibitor Name
                                            </th>
                                            <th>
                                                Result
                                            </th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        @foreach($event->booths as $booth)
                                        <tr>
                                            <td>
                                                AB.01
                                            </td>
                                            <td>
                                                27.00
                                            </td>
                                            <td>
                                                ME.BER Srl Unipersonale
                                            </td>
                                            <td>
                                                <div class="result-icon gold d-flex align-items-center">
                                                    <i class='bx bxs-circle me-2'></i>
                                                    <span>
                                                        Gold
                                                    </span>
                                                </div>
                                            </td>
                                            <td>
                                                <a href="booth-details.php" class="btn btn-outline-secondary">
                                                    Details11
                                                </a>
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="navs-pills-top-profile" role="tabpanel">
                            <div class="text-nowrap table-responsive user-table">
                                <table class="table mb-4 table-hover ">
                                    <thead>
                                        <tr>
                                            <th>
                                            Event Name
                                            </th>
                                            <th>
                                                Halls
                                            </th>
                                            <th>
                                                Start Date
                                            </th>
                                            <th>
                                                End Date
                                            </th>
                                            <th>
                                                Assign User
                                            </th>
                                            <th>
                                                Actions
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Sophia
                                            </td>
                                            <td>
                                                <a href="view-event.php" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Lukas
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Alexander
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Aurora
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Matteo
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Elena
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Maximilian
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Isabella
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Antonio
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Olivia
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="navs-pills-top-messages" role="tabpanel">
                            <div class="text-nowrap table-responsive user-table">
                                <table class="table mb-4 table-hover ">
                                    <thead>
                                        <tr>
                                            <th>
                                            Event Name
                                            </th>
                                            <th>
                                                Halls
                                            </th>
                                            <th>
                                                Start Date
                                            </th>
                                            <th>
                                                End Date
                                            </th>
                                            <th>
                                                Assign User
                                            </th>
                                            <th>
                                                Actions
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Sophia
                                            </td>
                                            <td>
                                                <a href="view-event.php" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Lukas
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                {{ $event->name }}
                                            </td>
                                            <td>
                                                {{ $event->num_halls }}
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Alexander
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Aurora
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Matteo
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Elena
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Maximilian
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Isabella
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Antonio
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Mena Telehealth
                                            </td>
                                            <td>
                                                05
                                            </td>
                                            <td>
                                                10-11-2024
                                            </td>
                                            <td>
                                                16-11-2024
                                            </td>
                                            <td>
                                                Olivia
                                            </td>
                                            <td>
                                                <a href="#" class="btn btn-outline-secondary">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class = "col-12">
                <div class="card p-0 mb-2">
                    <div class="card-body d-flex flex-column flex-md-row justify-content-between p-0">
                        <div class="row card-body align-items-md-center text-md-center justify-content-center">
                        <div class = "col-lg-8 col-xl-6">
                            <div class="d-flex align-items-center justify-content-between">
                                <input type="search" placeholder="Search Booth by Code or Name" class="form-control me-2">
                                <button type="submit" class="btn btn-dark btn-icon"><i class="bx bx-search-alt"></i></button>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 mb-2">
                <div class="card">
                    <div class="card search-card m-3 shadow-none d-none">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-8 col-md-9 mb-3 mb-sm-0">
                                    <div class="form-group">
                                        <input type="text" class="form-control" placeholder="Search Booth by Code or Name">
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-3">
                                    <div class="form-group">
                                        <button type="button" class="btn btn-dark w-100">
                                            <span class="tf-icons bx bx-search-alt me-1"></span> Search
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-header border-bottom">
                        <div class="b-table-header">
                            <div class="row pb-2 booth-title justify-content-between">
                                <div class="col-xl-3 mb-3 mb-xl-0">
                                    <select id="userSelect" class="form-select usertype-select wide mb-3 mb-md-0">
                                        <option data-display = "Select Hall">Nothing</option>
                                        <option value="1">Hall 1</option>
                                        <option value="2">Hall 2</option>
                                        <option value="3">Hall 3</option>
                                        <option value="4">Hall 4</option>
                                        <option value="5">Hall 5</option>
                                        <option value="6">Hall 6</option>
                                        <option value="7">Hall 7</option>
                                        <option value="8">Hall 8</option>
                                        <option value="9">Hall 9</option>
                                        <option value="10">Hall 10</option>
                                    </select>
                                </div>

                                <div class="col-xl-9">
                                    <div class = "row">
                                        <div class = "col-6">
                                                <div class="d-flex align-items-center">
                                                <div class = "hall-name d-flex align-items-center">
                                                    <h5 class = "mb-0">Hall 1</h5>
                                                    <button class="btn btn-icon p-0 border-0 background-transparent"
                                                    data-bs-toggle = "modal" data-bs-target = "#editHallModal">
                                                        <span class="tf-icons bx bx-edit"></span>
                                                    </button>
                                                </div>
                                                <h5 class = "mb-0 ms-2 ms-md-4">Total Booths: 130</h5>
                                            </div>
                                        </div>
                                        <div class = "col-6">
                                                <div class = "row">
                                                <div class = "col-6">
                                                    <button class="btn btn-outline-primary w-100">
                                                        <i class="bx bx-export me-1"></i> Import Booths
                                                    </button>
                                                </div>
                                                <div class = "col-6">
                                                    <button data-bs-toggle = "modal" data-bs-target = "#addBoothModal"
                                                    class="btn btn-secondary add-new btn-primary w-100" type="button">
                                                        <span>
                                                            <i class="bx bx-plus me-0 me-sm-1"></i>
                                                            <span class="d-inline-block">Add Booth</span>
                                                        </span>
                                                    </button>
                                                </div>
                                                </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row py-3 align-items-center d-none">
                                <div class = "col-12 col-md-8 mb-3 mb-md-0">
                                    <div class="d-flex align-items-center justify-content-end justify-content-md-start">
                                        <div class = "hall-name d-flex align-items-center">
                                            <h4 class = "mb-0">Hall 1</h4>
                                            <button class="btn btn-icon p-0 border-0 background-transparent"
                                            data-bs-toggle = "modal" data-bs-target = "#editHallModal">
                                                <span class="tf-icons bx bx-edit"></span>
                                            </button>
                                        </div>
                                        <h4 class = "mb-0 ms-2 ms-md-4">Total Booths: 130</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-4 text-end">
                                    <div class="form-group">
                                        <input type="text" class="form-control" placeholder="search">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="text-nowrap table-responsive user-table booth-table">
                        <table class="table mb-4 table-hover ">
                            <thead>
                                <tr>
                                    <th>
                                        Booth Number
                                    </th>
                                    <th>
                                        Booth Size m<sup>2</sup>
                                    </th>
                                    <th>
                                        Exhibitor Name
                                    </th>
                                    <th>
                                        Result
                                    </th>
                                    <th>
                                        Actions
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon gold d-flex align-items-center">
                                            <img src="assets/images/elements/Gold-star.svg" alt="Credit Card" class="me-2" width="20" height="auto">
                                            <span>
                                                Gold
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon silver d-flex align-items-center">
                                            <img src="assets/images/elements/Silver-star.svg" alt="Silver Card" class="me-2" width="20" height="auto">
                                            <span>
                                                Silver
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon bronze d-flex align-items-center">
                                            <img src="assets/images/elements/Bronze-star.svg" alt="Bronze Card" class="me-2" width="20" height="auto">
                                            <span>
                                                Bronze
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon disposable d-flex align-items-center">
                                            <span>
                                                Disposable
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon gold d-flex align-items-center">
                                            <img src="assets/images/elements/Gold-star.svg" alt="Credit Card" class="me-2" width="20" height="auto">
                                            <span>
                                                Gold
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon silver d-flex align-items-center">
                                            <img src="assets/images/elements/Silver-star.svg" alt="Silver Card" class="me-2" width="20" height="auto">
                                            <span>
                                                Silver
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        AB.01
                                    </td>
                                    <td>
                                        27.00
                                    </td>
                                    <td>
                                        ME.BER Srl Unipersonale
                                    </td>
                                    <td>
                                        <div class="result-icon pending d-flex align-items-center">
                                            <span>
                                                N/A
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="booth-details.php" class="btn btn-outline-secondary">
                                            Details
                                        </a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
            <!-- / Content -->

            <div class="content-backdrop fade"></div>
    <!-- / Content -->
    <div class="modal fade" id="addBoothModal" tabindex="-1" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel1">Add Booth</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('booths.store') }}" method="post" id="boothreg">
                    @csrf
                    <div class="modal-body">
                        @if (session()->has('success'))
                            <div class="alert alert-success">
                                {{ session()->get('success') }}
                            </div>
                        @elseif(session()->has('failed'))
                            <div class="alert alert-danger">{{ session('failed') }}</div>
                        @endif
                        <div class="row">
                            <div class="col mb-3">
                                <label for="exhibitor_name" class="form-label">Exhibitor Name</label>
                                <input type="text" id="exhibitor_name" class="form-control" name="exhibitor_name" value="{{ old('exhibitor_name') }}" placeholder="Enter Exhibitor Name">
                                <div id="exhibitor_nameError" class="form-error mt-1">@error('exhibitor_name'){{ $message }}@enderror</div>
                            </div>
                        </div>
                        <input type="hidden" name="event_id" value="{{ $event->id }}">
                        <div class="row">
                            <div class="col mb-3">
                            <label for="number" class="form-label">Booth Number</label>
                            <input type="text" id="number" class="form-control" name="number" value="{{ old('number') }}" placeholder="Enter Booth Number">
                            <div id="numberError" class="form-error mt-1">@error('number'){{ $message }}@enderror</div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col mb-3">
                            <label for="size" class="form-label">Booth Size M<sup>2</sup></label>
                            <input type="text" id="size" class="form-control" name="size" value="{{ old('size') }}"  placeholder="Enter Booth Size">
                            <div id="sizeError" class="form-error mt-1">@error('size'){{ $message }}@enderror</div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col mb-3">
                            <label for="hall" class="form-label">Select Hall</label>
                                <select id="hall" name="hall" class="form-select usertype-select wide mb-3 mb-md-0">
                                    <option value="">Select hall</option>
                                    @for($z=1;$z<=$event->num_halls;$z++)
                                    <option value="{{ $z }}" @if($z==old('hall')){{ "selected" }}@endif>Hall {{ $z }}</option>
                                    @endfor
                                </select>
                                <div id="hallError" class="form-error mt-1">@error('hall'){{ $message }}@enderror</div>
                            </div>
                        </div>
                    </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Close
                    </button>
                    <button type="submit" class="btn btn-primary">Add Booth</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    @if ($errors->any() || session()->has('success') || session()->has('failed'))
    <script>
        $("document").ready(function(){

            $("#addBoothModal").modal('show');


        });
    </script>


    @endif

    <script>
        $(document).ready(function() {




            $('#boothreg').validate({
                ignore: [],
                rules: {

                    exhibitor_name: {
                        required: true,
                        //noNumbers: true,
                        // maxlength: 32
                    },
                    hall:{
                        required:true
                    },
                    size:{
                        required:true
                    },
                    number:{
                        required:true
                    }



                },
                messages: {


                    exhibitor_name: {
                        required: "Please provide exhibitor's name",

                    },
                    hall:{
                        required: "Please Select a Hall",
                    },
                    size:{
                        required:"Please enter the stand size"
                    },
                    number:{
                        required:"Please enter booth number"
                    }

                },
                errorPlacement: function(error, element) {
                    var errorElementId = element.attr('id') +
                        'Error'; // Get the ID of the corresponding error message div
                    $('#' + errorElementId).text(error
                        .text()
                    ); // Insert the error message text into the corresponding error message div
                },
                highlight: function(element, errorClass, validClass) {
                    var value = $(element).val();
                    var hasUpperCase = /[A-Z]/.test(value);
                    var hasLowerCase = /[a-z]/.test(value);
                    var hasNumber = /\d/.test(value);
                    var hasSpecialChar = /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(value);
                    var passwordLength = value.length;

                    // Check if the element being validated is the password field
                    if (element.id === 'password') {
                        if (hasUpperCase) {
                            $('.password-instruction b:contains("uppercase")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("uppercase")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasLowerCase) {
                            $('.password-instruction b:contains("lowercase")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("lowercase")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasNumber) {
                            $('.password-instruction b:contains("number")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("number")').addClass('invalid')
                                .removeClass('valid');
                        }

                        if (hasSpecialChar) {
                            $('.password-instruction b:contains("special character")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction b:contains("special character")').addClass(
                                'invalid').removeClass('valid');
                        }

                        if (passwordLength >= 8) {
                            $('.password-instruction').find('b:contains("8")').addClass('valid')
                                .removeClass('invalid');
                        } else {
                            $('.password-instruction').find('b:contains("8")').addClass('invalid')
                                .removeClass('valid');
                        }
                    }
                },
                unhighlight: function(element, errorClass, validClass) {
                    var errorElementId = $(element).attr('id') + 'Error';
                    $('#' + errorElementId).empty();
                },
                submitHandler: function(form) {
                    form.submit(); // Submit the form if all validation passes
                }
            });

            $.validator.addMethod("noNumbers", function(value, element) {
                return this.optional(element) || !/\d/.test(value);
            }, "Your name cannot contain any numbers.");

            $('#registrationForm input').keyup(function() {
                $('#registrationForm').validate().element($(this));
            });
            $("#generatePassword").click(function(event) {
                event.preventDefault();
                var pass = generatePassword();
                $("#password").val(pass);
            });
        });
    </script>
@endsection
