@extends('layouts.app')
@php
    $currentPage = 'edit-events';
@endphp
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class = "dashboard-body">
            <div class="row">
                <div class="col-md-12 col-lg-8 col-xl-7">
                    <div class="card mb-2">
                        <div class="card-body overflow-hidden">


                            <form action="{{ route('events.update', $event->id) }}" id="registrationForm" method="post">
                                @csrf
                                <input type="hidden" name="_method" value="PUT">
                                <div class="mb-3">
                                    <label for="eventTitle" class="form-label">Event Title</label>
                                    <input type="text" class="form-control" name="name" id="eventTitle"
                                        placeholder="Name" value="{{ $event->name }}">
                                    <div id="eventTitleError" class="form-error mt-1">
                                        @error('name')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="row">
                                        <div class="col-md-6 mb-3 mb-md-0">
                                            <label for="eventstartdate" class="form-label">Event Start Date</label>
                                            <input class="form-control" name="start_at" type="date"
                                                value="{{ \Carbon\Carbon::parse($event->start_at)->format('Y-m-d') }}"
                                                id="start_date" onchange="setMinDates(event)">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="eventenddate" class="form-label">Event End Date</label>
                                            <input class="form-control" name="end_at" type="date"
                                                value="{{ \Carbon\Carbon::parse($event->end_at)->format('Y-m-d') }}"
                                                id="end_date" onchange="setMaxDates(event)">
                                                <div id="end_dateError" class="form-error mt-1">
                                                    <!-- Error message for end_date will be displayed here -->
                                                </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="eventInfo" class="form-label">Event Info</label>
                                    <textarea class="form-control" name="info" id="eventInfo" rows="3">{{ $event->info }}</textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="userSelect" class = "form-label">Number of Halls</label>
                                    <select id="userSelect" class="form-select usertype-select wide mb-4" name="num_halls"
                                        >
                                        <option data-display = "Select">Noting</option>
                                        @for ($i = $event->num_halls; $i <= 50; $i++)
                                            <option value="{{ $i }}"
                                                @if ($i == $event->num_halls) {{ 'selected' }} @endif>
                                                {{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>



                                <div class="mb-3">
                                    <label for="exampleFormControlSelect2" class="form-label">Assign User</label>
                                    <select multiple="" class="form-select multiselect-events  "
                                        id="exampleFormControlSelect2" aria-label="Multiple select example"
                                        name="user_ids[]" multiple="multiple">
                                        <option value="">Select user</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}"
                                                @if ($event->users->contains($user->id)) {{ 'selected' }} @endif>
                                                {{ $user->name . '(' . $user->getRoleNames()->first() . ')' }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div id="exampleFormControlSelect2Error" class="form-error mt-1">
                                        @error('user')
                                            {{ $message }}
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 mt-4">
                                    <div class="row">
                                        <div class="col-12 text-end">
                                            <a href = "{{ route('events.index') }}" type="reset"
                                                class="btn btn-outline-secondary me-2">Cancel</a>
                                            <button type="submit" class="btn btn-primary">
                                                Update Event
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>
    <!-- / Content -->


    <script>
    let endDate_set = false;
    let startDate_set = false;

    function setMinDates(event) {
        startDate_set = true;
        $("#end_date").attr('min', event.target.value);
    }

    function setMaxDates(event) {
        endDate_set = true;
        $("#start_date").attr('max', event.target.value);
    }

    // Get today's date
    var today = new Date().toISOString().split('T')[0];
    $("#end_date").attr('min', today);

    $(document).ready(function() {
        // Custom validation method to check end date
        $.validator.addMethod("validEndDate", function(value, element) {
            return this.optional(element) || value >= today;
        }, "End date cannot be earlier than today.");

        $('#registrationForm').validate({
            ignore: [],
            rules: {
                name: {
                    required: true,
                },
                num_halls: {
                    required: true,
                },
                user_id: {
                    required: true
                },
                end_at: {
                    validEndDate: true
                }
            },
            messages: {
                name: {
                    required: "Please provide your full name",
                },
                user_id: {
                    required: "Please Select a user",
                },
                end_at: {
                    validEndDate: "End date cannot be earlier than today."
                }
            },
            errorPlacement: function(error, element) {
                var errorElementId = element.attr('id') + 'Error'; // Get the ID of the corresponding error message div
                $('#' + errorElementId).text(error.text()); // Insert the error message text into the corresponding error message div
            },
            highlight: function(element, errorClass, validClass) {
                var value = $(element).val();
            },
            unhighlight: function(element, errorClass, validClass) {
                var errorElementId = $(element).attr('id') + 'Error';
                $('#' + errorElementId).empty();
            },
            submitHandler: function(form) {
                form.submit(); // Submit the form if all validation passes
            }
        });

        $('#registrationForm input').keyup(function() {
            $('#registrationForm').validate().element($(this));
        });


    });
</script>

@endsection
