@extends('layouts.app')
@php
    $currentPage = 'booth-details';
    $eventName = $booth->event->name;
@endphp
@section('content')

<div class="container-xxl flex-grow-1 container-p-y">
        <div class = "dashboard-body">
            <div class="row">
                @can('add-rating')
                    <div class="col-12 mb-2">
                        <div class="card">
                            <div class="card-header border-bottom">
                                <div class="booth-detail-header">
                                    <div class="row align-items-center justify-content-between">
                                        <div class="col-sm-6 mb-1 mb-sm-0">
                                            <div class="exb-name">
                                                <h6 class = "mb-2">Exhibitor Name</h6>
                                                <h4>ME.BER Sri Unipersonale</h4>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 text-sm-end">
                                            <div class="booth-num mb-2">
                                                Stand Number: <span class="ms-2">ABD</span>
                                            </div>
                                            <div class="booth-size mb-2">
                                                Stand Size M<sup>2</sup>: <span class="ms-2">27.00</span>
                                            </div>
                                            <div class="reating-by">
                                                Stand assessment by: <span class="ms-2">Tim BLG Team</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <h4 class="my-3">
                        Please fillout the Booth Criteria information:
                    </h4>

                    <div class="rating-form rating-inline py-3">
                        <form action="{{ route('booth.detail.store', $booth->id) }}" method="post" class = "rating-form">
                            @csrf

                            @foreach ($criterias as $criteria)
                                <div class="col-12 mb-2">
                                    <div class="card">
                                        <div class="form-group border-bottom row px-3 mx-0 align-items-center">

                                            <div class="col-md-9 col-lg-10 mb-3 mb-md-0 py-3">
                                                <div class="label-question">
                                                    {{ $criteria->name }}
                                                </div>
                                            </div>

                                            <div class = "col-md-3 col-lg-2 py-3">
                                                <div class="form-row flex-center">
                                                    <input class="form-input yes" type="radio"
                                                        name="{{ 'criteria_' . $criteria->id }}" id="{{ $criteria->id }}_yes"
                                                        value="yes">
                                                    <label class="form-label" for="{{ $criteria->id }}_yes">YES</label>
                                                </div>
                                                <div class="form-row flex-center">
                                                    <input class="form-input no" type="radio"
                                                        name="{{ 'criteria_' . $criteria->id }}" id="{{ $criteria->id }}_No"
                                                        value="no">
                                                    <label class="form-label" for="{{ $criteria->id }}_No">NO</label>
                                                </div>
                                                <div class="form-row flex-center">
                                                    <input class="form-input na" type="radio"
                                                        name="{{ 'criteria_' . $criteria->id }}" id="{{ $criteria->id }}_N/A"
                                                        value="na">
                                                    <label class="form-label" for="{{ $criteria->id }}_N/A">N/A</label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <div class="col-12 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <div class = "upload-img">
                                                <label>Upload Booths Photos</label>
                                                <div class = "image-section">
                                                    <div class = "img-placeholder">
                                                        <div class = "user-img-ic">
                                                            <img src = "assets/images/icons/upload-product.svg"
                                                                alt = "icon" />
                                                        </div>
                                                        <div class = "title">
                                                            Drop files here or browse to upload <br>
                                                            Your can upload multiple photos here
                                                        </div>
                                                        <div class = "img-dimensions mt-2">
                                                            Up to 1 MB (JPG or PNG)
                                                        </div>
                                                    </div>
                                                    <div class = "image-show" style="display: none;">
                                                        <div class = "img-details">
                                                            <ul class = "nav">
                                                                <li class = "nav-item">
                                                                    <div class = "uploaded-image">
                                                                        <img id="uploaded-image-preview" src=""
                                                                            alt="Uploaded Image" />
                                                                    </div>
                                                                </li>
                                                                <li class = "nav-item">
                                                                    <div class = "product-name" id="product-name"></div>
                                                                    <div class = "product-size" id="product-size"></div>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="progress" style="height: 2px;">
                                                            <div class="progress-bar" id="progress-bar" role="progressbar"
                                                                style="width: 0%;" aria-valuenow="0" aria-valuemin="0"
                                                                aria-valuemax="100"></div>
                                                        </div>
                                                        <div class = "close-sec">
                                                        </div>
                                                    </div>
                                                    <input id = "upload-img-pu" type="file"
                                                        onchange="handleFileSelect(event)" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row py-2">
                                <div class="col-12 text-md-end">
                                    <a href="view-event.php" type="reset"
                                        class="btn btn-lg btn-outline-secondary me-md-2">Cancel</a>
                                    <button type="button" class="btn btn-secondary btn-lg me-md-2">
                                        Save Draft
                                    </button>
                                    <button type="submit" class="btn btn-primary btn-lg" data-bs-toggle = "modal"
                                        data-bs-target = "#successModal">
                                        Submit
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                @endcan

                @can('view-rating')
                    <div class="col-12 mb-4">
                        <div class="card">
                            <div class="card-header border-bottom">
                                <div class="booth-detail-header">
                                    <div class="row align-items-center justify-content-between">
                                        <div class="col-sm-6 mb-3 mb-sm-0">
                                            <div class="exb-name">
                                                <h6 class = "mb-2">Exhibitor Name</h6>
                                                <h4>ME.BER Sri Unipersonale</h4>
                                            </div>
                                            <div class="booth-rating">
                                                <div class="result-icon bronze d-flex align-items-center">
                                                    <h3 class = "mb-0">
                                                        <i class='bx bxs-circle me-1' style = "font-size:30px;"></i>
                                                        <span>
                                                            Bronze
                                                        </span>
                                                    </h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 text-sm-end">
                                            <div class="booth-num mb-2">
                                                Booth Number: <span class="ms-2">ABD</span>
                                            </div>
                                            <div class="booth-size mb-2">
                                                Booth Size M<sup>2</sup>: <span class="ms-2">27.00</span>
                                            </div>
                                            <div class="reating-by">
                                                Booth Reating By: <span class="ms-2">Tim BLG Team</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive booth-d-table">
                                <table class="table mb-4 table-hover ">
                                    <thead>
                                        <tr>
                                            <th>
                                                Criteria
                                            </th>
                                            <th>
                                                Feedback
                                            </th>
                                        </tr>
                                    </thead>
                                    {{-- <tbody class="table-border-bottom-0">
                                        <tr>
                                            <td>
                                                Stand Structure & Walls
                                                (e.g. Structure or framework of the stand, walls, panels for meeting rooms,
                                                backdrop.)
                                            </td>
                                            <td>
                                                @if ($booth->rating->stand_structure == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->stand_structure=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Platform / Raised Flooring (Structure of flooring excluding surface covering, e.g.
                                                carpet)
                                            </td>
                                            <td>
                                                @if ($booth->rating->plateform_raised_flooring == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->plateform_raised_flooring=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Furniture & Equipment (Counters, chairs, tables, sofa, coffee table, cabinet, flyer
                                                stand, LED walls, TV, AV equipment etc.)
                                            </td>
                                            <td>
                                                @if ($booth->rating->furniture_equipments == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->furniture_equipments=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Lighting (e.g. All kinds of lightings in the stand and showcases)
                                            </td>
                                            <td>
                                                @if ($booth->rating->lighting == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->lighting=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Fascia and/or Overhead Signage (Overhead signage or branding, Fascia, company logo
                                                on top of the stand structure)
                                            </td>
                                            <td>
                                                @if ($booth->rating->fascia_signage == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->fascia_signage=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Rigged Structure (Any rigged structure including lighting gantries or other
                                                structural elements.)
                                            </td>
                                            <td>
                                                @if ($booth->rating->rigged_structure == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->rigged_structure=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Ceiling (Any form of ceiling e.g. fabric ceiling, solid ceiling for lights or stand
                                                support)
                                            </td>
                                            <td>
                                                @if ($booth->rating->ceiling == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->ceiling=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Display Facilities (Built-in or Detachable product display cabinets, Lightboxes etc)
                                            </td>
                                            <td>
                                                @if ($booth->rating->display_facilities == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->display_facilities=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Flooring (e.g. carpeting, floor tiling, HDF coverings)
                                            </td>
                                            <td>
                                                @if ($booth->rating->flooring == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->flooring=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Graphics & Decorative Items (e.g. Stand graphics that are wall mounted or floor
                                                standing not overhead and any other decorative items such as plants & flowers,
                                                models or ornaments)
                                            </td>
                                            <td>
                                                @if ($booth->rating->graphics_decorative_items == 'yes')
                                                    <span class="badge bg-success">YES</span>
                                                @elseif($booth->rating->graphics_decorative_items=='no')
                                                    <span class="badge bg-danger">NO</span>
                                                @else
                                                    <span class="badge bg-secondary">N/A</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody> --}}
                                </table>
                            </div>

                        </div>
                    </div>

                    <div class="col-12 mb-4">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="mb-0">Booths Pictures</h4>
                            </div>
                            <div class="card-body">
                                <section class="photo-gallery">
                                    <div class="container">
                                        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 gallery-grid">
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://cdn.socio.events/spai/q_glossy+w_966+to_avif+ret_img/socio.events/wp-content/uploads/2023/02/MG_1418-2048x1365.jpg">
                                                    <img src="https://cdn.socio.events/spai/q_glossy+w_966+to_avif+ret_img/socio.events/wp-content/uploads/2023/02/MG_1418-2048x1365.jpg"
                                                        class="img-fluid" alt="Lorem ipsum dolor sit amet">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://www.expomarketing.com/wp-content/uploads/2019/01/dwell-segment-optimized.jpg">
                                                    <img src="https://www.expomarketing.com/wp-content/uploads/2019/01/dwell-segment-optimized.jpg"
                                                        class="img-fluid" alt="Ipsum lorem dolor sit amet">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://exhibitcentral.com.au/wp-content/uploads/2023/09/trade-show-booths.webp">
                                                    <img src="https://exhibitcentral.com.au/wp-content/uploads/2023/09/trade-show-booths.webp"
                                                        class="img-fluid" alt="Dolor lorem ipsum sit amet">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://static.commerceplatform.services/images/trus10bkzz.rw-500x300.jpg">
                                                    <img src="https://static.commerceplatform.services/images/trus10bkzz.rw-500x300.jpg"
                                                        class="img-fluid" alt="Sit amet lorem ipsum dolor">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://cdn.tentcraft.com/images/blog/10x10_trade-show_booth_ideas/10x10-pop-up.jpg">
                                                    <img src="https://cdn.tentcraft.com/images/blog/10x10_trade-show_booth_ideas/10x10-pop-up.jpg"
                                                        class="img-fluid" alt="Aut ipsam deserunt nostrum quo">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://img.tradefest.io/filters:quality(80)/filters:format(.webp)/fit-in/2048x0/blog/images/c8cbebd1afd822120693f224a9d70bfaa9ddebde_fabuwood_002">
                                                    <img src="https://img.tradefest.io/filters:quality(80)/filters:format(.webp)/fit-in/2048x0/blog/images/c8cbebd1afd822120693f224a9d70bfaa9ddebde_fabuwood_002"
                                                        class="img-fluid" alt="Nulla ex nihil eligendi tempora">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://marvel-b1-cdn.bc0a.com/f00000000292131/skyline.com/hubfs/skyline-skyflyer-booth-design-trends-exhibits-designer.jpg">
                                                    <img src="https://marvel-b1-cdn.bc0a.com/f00000000292131/skyline.com/hubfs/skyline-skyflyer-booth-design-trends-exhibits-designer.jpg"
                                                        class="img-fluid" alt="Nemo perspiciatis voluptatum">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://www.triumfo.de/admin/blog/1666181818.webp">
                                                    <img src="https://www.triumfo.de/admin/blog/1666181818.webp"
                                                        class="img-fluid" alt="Accusantium consequuntur modi">
                                                </a>
                                            </div>
                                            <div class="col">
                                                <a class="gallery-item"
                                                    href="https://classicexhibits.com/tradeshow-blog/wp-content/uploads/2022/01/trade-show-booth-design.jpeg">
                                                    <img src="https://classicexhibits.com/tradeshow-blog/wp-content/uploads/2022/01/trade-show-booth-design.jpeg"
                                                        class="img-fluid" alt="Dolore asperiores reprehenderit">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                @endcan

            </div>
        </div>
    </div>
    <!-- / Content -->

    <div class="content-backdrop fade"></div>

    <script>
        function handleFileSelect(event) {
            const file = event.target.files[0];
            const imagePreview = document.getElementById('uploaded-image-preview');
            const productName = document.getElementById('product-name');
            const productSize = document.getElementById('product-size');

            // Show the uploaded image and file details
            if (file) {
                const reader = new FileReader();
                reader.onload = function() {
                    imagePreview.src = reader.result;
                    document.querySelector('.image-show').style.display = 'block';
                    productName.textContent = file.name;
                    productSize.textContent = `${(file.size / 1024).toFixed(2)} KB`;
                };
                reader.readAsDataURL(file);

                // Animate the progress bar
                const progressBar = document.getElementById('progress-bar');
                progressBar.style.width = '0%';
                progressBar.addEventListener('transitionend', () => {
                    progressBar.classList.add('bg-success');
                });
                setTimeout(() => {
                    progressBar.style.width = '100%';
                }, 300);
            }
        }
    </script>
    <!-- / Content -->
@endsection
