<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'user-list',
            'user-create',
            'user-edit',
            'user-delete',
            'event-list',
            'view-event',
            'delete-event',
            'event-create',
            'event-edit',
            'booth-list',
            'booth-create',
            'booth-delete',
            'booth-hall-edit',
            'add-rating',
            'view-rating',
            'generate-stands-report',



        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }
    }
}
