<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booth_ratings', function (Blueprint $table) {

            $table->id();
            $table->foreignId('booth_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('question_id')->constrained()->onDelete('cascade');
            // $table->enum('result', ['GOLD', 'BRONZE', 'SILVER', 'DISPOSABLE', 'NOT'])->default('NOT');
            $table->enum('result', ['yes', 'no', 'na'])->default('na');
            //$table->boolean('draft')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booth_ratings');
    }
};
