<?php

namespace App\Traits;

use Exception;
use App\Models\Criteria;
use Illuminate\Support\Facades\Log;

trait CategorizesBoothRatings
{
    public function determineCategory($boothRatings,$isObject=false)
    {
        try{
            $criteriaList = Criteria::all();
            $result = 'Nill';
            $results = [];
            if ($isObject) {
                // Group booth ratings by question slug
                $ratings = $boothRatings->mapWithKeys(function ($rating) {
                    $result = $rating->result === 'na' ? 'yes' : $rating->result;
                    return [$rating->question->slug => $result];
                });
            } else {
                $ratings = $boothRatings;
            }
            //dd(count($ratings));
            if (count($ratings) > 0 && ($ratings['stand_structure_walls'] == 'no' || $ratings['plateform_raised_flooring'] == 'no' || $ratings['furniture_equipments'] == 'no' || $ratings['lighting'] == 'no')) {
                return ['Disposable'];
            }
            foreach ($criteriaList as $criteria) {
                $matches = true;
                $no_na = 0;
                $isNo = false;
                foreach ($criteria->criteria as $slug => $expectedResult) {

                    if (isset($ratings[$slug]) && $ratings[$slug] != 'na') {
                        $no_na++;
                    }
                    if (isset($ratings[$slug])) {
                        $ratings[$slug] = $ratings[$slug] == 'na' ? 'yes' : $ratings[$slug];
                    }

                    if (!isset($ratings[$slug]) || $ratings[$slug] !== $expectedResult) {
                        $matches = false;
                        break;
                    }
                }
                if ($no_na == 0) {
                    return ['NOT'];
                } elseif ($matches) {
                    $results[] = $criteria->category;
                }
            }
            if (count($results) > 0) {
                return $results;
            } else {
                return ['NOT'];
            }
        }catch(Exception $ex){
            Log::info('Error in categorize Booth Rating trait. error '.$ex->getMessage());
            return ['NOT'];
        }


    }
}
