<?php

namespace App\Repositories;

use App\Interfaces\BoothInterface;
use App\Models\Booth;
use App\Models\BoothRating;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class BoothRepository implements BoothInterface
{
    public  function getAllBooths($search = null, $event = null,$hall_id=null,$category=null)
    {
        try {

            $query = Booth::query();

            if ($event) {
                $query->where('event_id', $event);
            }

            if ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where('number', 'LIKE', '%' . $search . '%')
                        ->orWhere('exhibitor_name', 'LIKE', '%' . $search . '%');
                });
            }
            if($hall_id!=null && $hall_id!='0'){
                $query->where('hall_id',$hall_id);
            }
            if($category && $category!='all' && $category!= 'Nothing'){
                $query->where('result',$category);
            }

            $booths = $query->with('event')->with('standType')->orderBy('id', 'desc')->get();

            return $booths;
        } catch (Exception $e) {

            Log::error("Error getting all booths" . $e->getMessage());
            throw new \Exception('Error retrieving booths', 500);
        }
    }

    public function getAllBoothsByHall($hall_id, $event_id, $search = null, $category=null)
    {
        try {

            // Base query
            $query = Booth::where('event_id', $event_id)->with('standType');

            // Filter by hall_id if it's not 0
            if ($hall_id != 0) {
                $query->where('hall_id', $hall_id);
            }

            // Add search conditions if $search is provided
            if ($search && $search!='') {
                $query->where(function ($q) use ($search) {
                    $q->where('exhibitor_name', 'like', '%' . $search . '%')
                        ->orWhere('number', 'like', '%' . $search . '%');
                });
            }
            if($category!=null && $category!='all' && $category!= 'Nothing'){
                $query->where('result',$category);
            }

            // Execute the query and get the results
            $booths = $query->get();
            return $booths;
        } catch (Exception $e) {
            Log::info("Error getting booths by Hall: " . $e->getMessage());
        }
    }

    public function getAllBoothsByCategory($category, $event_id, $hall_id = null, $search = null)
    {
        try {
            // Base query
            $query = Booth::where('event_id', $event_id)->with('standType');

            // Filter by category if it's not 'all'
            if ($category != 'all') {
                $query->where('draft', false);
                $query->where('result', $category);
            }

            // Filter by hall_id if provided
            if ($hall_id && $hall_id!='0') {
                $query->where('hall_id', $hall_id);
            }

            // Add search conditions if $search is provided
            if ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where('exhibitor_name', 'like', '%' . $search . '%')
                        ->orWhere('number', 'like', '%' . $search . '%');
                });
            }

            // Execute the query and get the results
            $booths = $query->get();
            return $booths;
        } catch (Exception $e) {
            Log::info("Error getting booths by Stand: " . $e->getMessage());
        }
    }

    public function createBooth($data)
    {

        try {
            $area = $data['length'] * $data['width'];
            $merged_data=array_merge($data,['size'=> $area]);
            Booth::create($merged_data);
            return true;
        } catch (Exception $ex) {

            Log::error("Error while Creating booth" . $ex->getMessage());
            return false;
        }
    }

    public function countBooths()
    {

        return Booth::count();
    }
    public function getBoothData($id)
    {
        $booth = Booth::with('event')->findOrFail($id);
        return $booth;
    }
    public function updateBooth($request, $id)
    {
        try {
            $booth = Booth::whereId($id)->first();
            $booth->number = $request['name'];
            $booth->info = $request['info'];
            $booth->start_at = $request['start_at'];
            $booth->end_at = $request['end_at'];
            $booth->num_halls = $request['num_halls'];
            $booth->user_id = $request['user_id'];
            $booth->update();
            return true;
        } catch (Exception $ex) {
            Log::error("Error getting Updating booth" . $ex->getMessage());
            return false;
        }
    }
    public function updateRating($ratings,$id){
        BoothRating::where('booth_id', $id)->delete();
        foreach($ratings as $key=>$value){
            $question_id=explode('criteria_', $key);
            $question_id= $question_id[1];
            BoothRating::Create(['booth_id' => $id, 'user_id' => Auth::user()->id, 'question_id'=> $question_id, 'result'=> $value]);
        }



        return true;



    }
    public function deleteBooth($id)
    {
        try {
            $booth = Booth::findOrFail($id);
            $booth->delete();
            return true;
        } catch (Exception $ex) {
            Log::error("Error while deleting booth" . $ex->getMessage());
            return false;
        }
    }
}
