<?php

namespace App\Providers;

use App\Interfaces\UserInterface;
use App\Interfaces\BoothInterface;
use App\Interfaces\EventInterface;
use App\Repositories\UserRepository;
use Illuminate\Pagination\Paginator;
use App\Repositories\BoothRepository;
use App\Repositories\EventRepository;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(UserInterface::class, UserRepository::class);
        $this->app->bind(EventInterface::class, EventRepository::class);
        $this->app->bind(BoothInterface::class, BoothRepository::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Validator::extend('validPhoneNumber', function ($attribute, $value, $parameters, $validator) {
            // Regex to match valid phone numbers
            $regex = '/^(\+?\d{1,4})?(\d{10,14})$/';
            return preg_match($regex, $value);
        }, 'Please enter a valid phone number (11 to 15 digits, optionally starting with a country code).');
        Paginator::useBootstrap();
    }
}
