<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model
{
    protected $fillable=['name', 'start_at', 'end_at','info', 'num_halls'];
    use HasFactory;
    use SoftDeletes;
    public function users(){
        return $this->belongsToMany(User::class);
    }
    public function organizers()
    {
        return $this->belongsToMany(User::class)->whereHas('roles', function ($query) {
            $query->where('name', 'Organizer');
        });
    }
    public function booths(){
        return  $this->hasMany(Booth::class,'event_id');
    }
    public function halls(){
        return $this->hasMany(Hall::class);
    }

}
