<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BoothRating extends Model
{
    protected $guarded=[];
    use HasFactory;


    public function question(){
        return $this->belongsTo(Question::class,'question_id');
    }


    public static function determineCategory($boothRatings)
    {
        $criteriaList = Criteria::all();
        $results = [];

        // Group booth ratings by question slug
        $ratings = $boothRatings->mapWithKeys(function ($rating) {
            return [$rating->question->slug => $rating->result];
        });

        // Iterate through each criteria to determine if it matches the ratings
        foreach ($criteriaList as $criteria) {
            $matches = true;

            foreach ($criteria->criteria as $slug => $expectedResult) {
                if (!isset($ratings[$slug]) || $ratings[$slug] !== $expectedResult) {
                    $matches = false;
                    break;
                }
            }

            if ($matches) {
                $results[] = $criteria->category;
            }
        }

        return $results;
    }



}
