<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Interfaces\EventInterface;
use App\Interfaces\UserInterface;
use App\Models\Event;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $event;
    private $user;
    public function __construct(EventInterface $eventInterface,UserInterface $userInterface)
    {
        $this->middleware('auth');
        $this->event=$eventInterface;
        $this->user=$userInterface;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $user=null;
        //dd($user=Auth::user()->id);
        $role=Auth::user()->getRoleNames()->first();
        //$events=Event::all();
        if($role== 'User' || $role =='Organizer'){
            $user=Auth::user()->id;
            $events= Auth::user()->event;
            //dd($events);
        }
        $countEvents=$this->event->countEvents(null,$user);
        $countCompleted= $this->event->countEvents('completed', $user);
        $countCompletedPercentage= ($countEvents!=0)?round(($countCompleted/ $countEvents)*100):0;
        //return $countCompletedPercentage;
        $countProgressPercentage= ($countEvents != 0)?100- $countCompletedPercentage:0;
        //dd($countCompleted);
        $countProgress= $this->event->countEvents('progress', $user);
        $countGoldtemp= $this->event->countEvents('GOLD', $user);
        //dd($countGoldtemp);
        $countGold= $countGoldtemp['eventsCount'];
        $sizeGold = $countGoldtemp['size'];
        $countBronzetemp = $this->event->countEvents('BRONZE', $user);
        $countBronze= $countBronzetemp['eventsCount'];
        $sizeBronze = $countBronzetemp['size'];
        $countSilvertemp = $this->event->countEvents('SILVER', $user);
        $countSilver= $countSilvertemp['eventsCount'];
        $sizeSilver= $countSilvertemp['size'];
        $countDisposable = $this->event->countEvents('DISPOSABLE', $user);
        $search = $request->get('search');
        if ($search != null) {
            $events = $this->event->getAllEvents($search, $user);
        } else {
            $events = $this->event->getAllEvents(null,$user);


            //dd($events);
        }
        $eventsDropdown= $this->event->getAllEvents(null, $user,false);

        return view('home',['countCompletedPercentage'=> $countCompletedPercentage, 'countProgressPercentage'=> $countProgressPercentage,'search'=>$search,'events'=>$events,'countEvents'=> $countEvents, 'countCompleted'=> $countCompleted, 'eventsDropdown'=> $eventsDropdown,'countProgress'=> $countProgress, 'countGold'=> $countGold, 'countBronze'=> $countBronze, 'countSilver'=> $countSilver, 'countDisposable'=> $countDisposable,'sizeGold'=>$sizeGold,'sizeBronze'=>$sizeBronze,'sizeSilver'=>$sizeSilver]);
    }
    public function profile(){
        $id=Auth::user()->id;
        $user = $this->user->getUserData($id);
        return view('admin.users.profile',['user'=>$user]);
    }
    public function update(Request $request, string $id)
    {

        $request->validate([

            'name' => 'required',
            //'password' => 'required|min:8',
        ]);

        $updated = $this->user->updateProfile($request->all(), $id);
        if ($updated) {
            return redirect()->back()->with('success', 'User Updated Successfully');
        } else {

            return  redirect()->back()->withInput()->with(['failed' => 'Failed to update user']);
        }
    }
}
