<?php

namespace App\Exports;

use Exception;
use ZipArchive;
use App\Models\User;
use App\Models\Booth;
use App\Models\Event;
use App\Models\Comment;
use App\Models\Question;
use App\Models\BoothImage;
use App\Models\BoothRating;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\FromCollection;

class BoothExport implements FromCollection
{
    protected $event_id;
    private $eventName;
    private $eventStartDate;

    private $eventEndDate;
    public function __construct($event_id)
    {
        $this->event_id = $event_id;
        $this->eventName= Event::find($this->event_id)->name;
        $this->eventStartDate= Event::find($this->event_id)->start_at;
        $this->eventEndDate=Event::find($this->event_id)->end_at;

    }
    public function collection()
    {
        return Booth::with('hall', 'rating')
            ->where('event_id', $this->event_id)
            ->get();
    }

    public function export()
    {
        // Fetching questions from the database
        $questions = Question::all()->toArray();

        // Create new Spreadsheet object
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Top header table setup
        $headerData = [
            'Event Name' => $this->eventName,
            'Total number of stands' => Booth::where('event_id',$this->event_id)->count(),
            'Net m2 of all stands' => Booth::where('event_id', $this->event_id)->sum('size'),
            'Number of stands that are disposable' => Booth::where('event_id',$this->event_id)->where('result', 'DISPOSABLE')->count(), // Replace with actual logic
            'm2 of stands that are disposable' => Booth::where('event_id', $this->event_id)->where('result', 'DISPOSABLE')->sum('size'), // Replace with actual logic
            'Event Start Date'=>$this->eventStartDate,
            'Event End Date'=>$this->eventEndDate,

        ];

        // Calculate the starting column to center the header table
        $headerTableStartColumn = 'A';
        $headerTableEndColumn = 'G';

        // Add top header table with custom styling
        $col = $headerTableStartColumn;
        foreach ($headerData as $header => $value) {
            $sheet->setCellValue($col . '1', $header);
            $sheet->setCellValue($col . '2', $value);
            $col++;
        }

        // Apply styles to the top header table
        $sheet->getStyle($headerTableStartColumn . '1:' . chr(ord($headerTableEndColumn)) . '2')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'D8E4BC'], // light green color for cell background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);

        // Set the height of the top header table
        $sheet->getRowDimension('1')->setRowHeight(40); // Increase height for row 1
        $sheet->getRowDimension('2')->setRowHeight(30); // Increase height for row 2

        // Set custom table headers for main data table

        $sheet->setCellValue('A3', 'Team Member Marking Stands');
        $sheet->setCellValue('B3', 'Hall');

        $sheet->setCellValue('C3', 'Stand Number');
        $sheet->setCellValue('D3', 'Total Stand Size');
        $sheet->setCellValue('E3', 'Exhibitor Name');
        $sheet->setCellValue('F3','Stand Type');


        // Apply styles to custom table headers
        $sheet->getStyle('A3:G3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Light blue color for headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],

            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);

        // Set column headers dynamically from questions table
        $col = 'G'; // Start column for questions headers
        foreach ($questions as $question) {
            $sheet->setCellValue($col . '3', $question['name']);
            $sheet->getStyle($col . '3')->applyFromArray([
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => '000000'],
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'BFBFBF'], // Light grey color for questions headers background
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                ],
                'borders' => [
                    'outline' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => ['argb' => '000000'],
                    ],
                ],
            ]);
            $col++;
        }

        $sheet->setCellValue($col . '3', 'Comments');
        $sheet->getStyle($col . '3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Orange color for after questions headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
        $col++;
        $sheet->setCellValue($col.'3', 'Contractor Name');
        $sheet->getStyle($col . '3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Orange color for after questions headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
        $col++;
        $sheet->setCellValue($col.'3', 'Contractor Email');
        $sheet->getStyle($col . '3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
        $col++;
        $sheet->setCellValue($col.'3', 'Contractor Phone');
        $sheet->getStyle($col . '3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
        $col++;


        $sheet->setCellValue($col . '3', 'Stand Result');
        $sheet->getStyle($col . '3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
        $col++;
        $sheet->setCellValue($col . '3',
            'Stand Images'
        );
        $sheet->getStyle($col . '3')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => '000000'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
        // Set header row height and wrap text
        $sheet->getRowDimension('3')->setRowHeight(80);
        $sheet->getStyle('A4:' . $col . '3')->getAlignment()->setWrapText(true);

        // Set fixed column width and enable text wrap for each column
        $columnsWidth = [
            'A' => 30,
            'B' => 15,
            'C' => 60,
            'D' => 25,
            'E' => 25,
            'F' => 35,


        ];

        foreach ($columnsWidth as $column => $width) {
            $sheet->getColumnDimension($column)->setWidth($width);
            $sheet->getStyle($column)->getAlignment()->setWrapText(true);
            $sheet->getStyle($column . 3)->applyFromArray([
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => '000000'],
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                ],
                'borders' => [
                    'outline' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => ['argb' => '000000'],
                    ],
                ],
            ]);



        }

        // Set fixed width and wrap text for dynamic question columns
        $questionColumnWidth = 60;
        $startQuestionCol = 'G';
        $endQuestionCol = chr(ord('G') + count($questions));
        foreach (range($startQuestionCol, $endQuestionCol) as $column) {
            $sheet->getColumnDimension($column)->setWidth($questionColumnWidth);
            $sheet->getStyle($column)->getAlignment()->setWrapText(true);
            $sheet->getStyle($column . '3')->applyFromArray([
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => '000000'],
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                ],
                'borders' => [
                    'outline' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => ['argb' => '000000'],
                    ],
                ],
            ]);
        }
        $next= $endQuestionCol++;
        $sheet->getColumnDimension($next)->setWidth(60);
        $sheet->getStyle($column)->getAlignment()->setWrapText(true);
        $next++;
        $sheet->getColumnDimension($next)->setWidth(30);
        $sheet->getStyle($column)->getAlignment()->setWrapText(true);
        $next++;
        $sheet->getColumnDimension($next)->setWidth(30);
        $sheet->getStyle($column)->getAlignment()->setWrapText(true);
        $next++;
        $sheet->getColumnDimension($next)->setWidth(30);
        $sheet->getStyle($column)->getAlignment()->setWrapText(true);
        $next++;
        $sheet->getColumnDimension($next)->setWidth(30);
        $sheet->getStyle($column)->getAlignment()->setWrapText(true);
        $next++;
        $sheet->getColumnDimension($next)->setWidth(90);
        $sheet->getStyle($column)->getAlignment()->setWrapText(true);


        // Fetch booths data
        $booths = $this->collection();

        // Populate data rows
        $row = 4; // Start from row 4 after headers

        foreach ($booths as $booth) {

            try{
                $images = BoothImage::where('booth_id', $booth->id)->get();

                $zipFileName =  $this->eventName . '_' . 'booth_' . preg_replace('/[\/\\\*\.]/', '-slash-', $booth->number) . 'images.zip';
                $zipFilePath = public_path($zipFileName);

                $zip = new ZipArchive;
                if ($zip->open($zipFilePath, ZipArchive::CREATE) === TRUE) {

                    foreach ($images as $key => $image) {
                        $counter = $key + 1;
                        $localImagePath = public_path('storage/' . $image->file);
                        $extensionArray = explode('.', $image->file);
                        $extensnsionCount = count($extensionArray);
                        $extension = $extensionArray[$extensnsionCount - 1];
                        $imageName = $image->name . '.' . $extension;
                        if (file_exists($localImagePath)) {
                            // $zip->addFile($localImagePath, basename($localImagePath));
                            $zip->addFile($localImagePath, $imageName);
                        }
                    }
                    $zip->close();
                    //break;
                }
                $downloadLink = ($images->count() > 0) ? asset($zipFileName) : '';
                $assesment_by = '';
                if ($booth->assesment_by != null) {
                    $assesment_by = User::find($booth->assesment_by)->name;
                }
                $sheet->setCellValue('A' . $row, $assesment_by);
                $sheet->setCellValue('B' . $row, optional($booth->hall)->name);
                $sheet->setCellValue('C' . $row, $booth->number);
                $sheet->setCellValue('D' . $row, $booth->size); // Assuming hall() method returns the hall model
                $sheet->setCellValue('E' . $row, $booth->exhibitor_name);
                $sheet->setCellValue('F' . $row, $booth->standType->name);
                foreach ($columnsWidth as $column => $width) {

                    $sheet->getStyle($column . $row)->applyFromArray([
                        'font' => [
                            'bold' => true,
                            'color' => ['rgb' => '000000'],
                        ],
                        'fill' => [
                            'fillType' => Fill::FILL_SOLID,
                            'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                        ],
                        'alignment' => [
                            'horizontal' => Alignment::HORIZONTAL_CENTER,
                            'vertical' => Alignment::VERTICAL_CENTER,
                        ],
                        'borders' => [
                            'outline' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    ]);
                }

                // Populate data from booth_ratings for each question
                $col = 'G';
                foreach ($questions as $question) {
                    $rating = $booth->rating->where('question_id', $question['id'])->first();
                    $sheet->setCellValue($col . $row, $rating ? $rating->result : ''); // Assuming 'result' is the field from booth_ratings
                    $sheet->getStyle($col . $row)->applyFromArray([
                        'font' => [
                            'bold' => true,
                            'color' => ['rgb' => '000000'],
                        ],
                        'fill' => [
                            'fillType' => Fill::FILL_SOLID,
                            'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                        ],
                        'alignment' => [
                            'horizontal' => Alignment::HORIZONTAL_CENTER,
                            'vertical' => Alignment::VERTICAL_CENTER,
                        ],
                        'borders' => [
                            'outline' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    ]);
                    $col++;
                }

                $boothComment = Comment::where('booth_id', $booth->id)->first();
                $boothComment = ($boothComment != null) ? $boothComment->comment : null;
                $sheet->setCellValue($col . $row, $boothComment);
                $sheet->getStyle($column . $row)->applyFromArray([



                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $col++;
                $sheet->setCellValue($col . $row, $booth->contractor_name);
                $sheet->getStyle($col . $row)->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['rgb' => '000000'],
                    ],
                    'fill' => [
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $col++;
                $sheet->setCellValue($col . $row, $booth->contractor_email);
                $sheet->getStyle($col . $row)->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['rgb' => '000000'],
                    ],
                    'fill' => [
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $col++;
                $sheet->setCellValue($col . $row, $booth->contractor_phone);
                $sheet->getStyle($col . $row)->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['rgb' => '000000'],
                    ],
                    'fill' => [
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $col++;
                $sheet->setCellValue($col . $row, $booth->result);
                $sheet->getStyle($col . $row)->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['rgb' => '000000'],
                    ],
                    'fill' => [
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $col++;
                $sheet->getStyle($col . $row)->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['rgb' => '0000FF'],
                    ],
                    'fill' => [
                        'fillType' => Fill::FILL_SOLID,
                        'startColor' => ['rgb' => 'BFBFBF'], // Orange color for questions headers background
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $sheet->getStyle($column)->getAlignment()->setWrapText(true);

                if ($downloadLink) {
                    $sheet->setCellValue($col . $row, $downloadLink);
                    $sheet->getCell($col . $row)->getHyperlink()->setUrl($downloadLink);
                }



                $row++;
            }catch(Exception $e){
                // Log the error and skip this booth
                Log::error("Error processing booth ID: {$booth->id}. Error: " . $e->getMessage());
                continue; //
            }
        }



        for ($i = 4; $i < $row; $i++) {
            //$color = ($i % 2 == 0) ? '8383d9' : 'aed6f1';
            $color= 'B8CCE4'; // Alternating between light blue and light purple
            $sheet->getStyle('A' . $i . ':' . $col . $i)->applyFromArray([
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => $color],
                ],
                'borders' => [
                    'outline' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => ['argb' => '000000'],
                    ],
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER, // Center align all data cells
                    'vertical' => Alignment::VERTICAL_CENTER,
                ],
                'setWrapText'=>true
            ]);
        }

        // Create Excel file
        $filename = $this->eventName.'reports_booths.xlsx';
        $path = public_path('exports/' . $filename);
        $writer = new Xlsx($spreadsheet);
        $writer->save($path);

        // Download Excel file and delete it after download
        return response()->download($path)->deleteFileAfterSend();
    }
}
